package com.yeejoin.amos.patrol.business.dao.repository;

import java.util.List;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.patrol.dao.entity.CatalogTree;
@Repository("catalogTreeDao")
public interface ICatalogTreeDao extends BaseDao<CatalogTree, Long> {
	
	@Query(value = "select * from p_catalog_tree WHERE parent_id = ?1 and org_code = ?2 order by id", nativeQuery = true)
	List<CatalogTree> findByParentIdAndOrgCode(long parentId,String orgCode);
	
	@Query(value = "select * from p_catalog_tree WHERE parent_id = ?1 order by id", nativeQuery = true)
	List<CatalogTree> findChildrenByParentId(Long parentId);

	@Modifying
	@Transactional
	@Query(value = "delete from p_catalog_tree WHERE id in (?1)", nativeQuery = true)
	void deleteBatchById(Long[] ids);
	
	@Query(value = "select * from p_catalog_tree WHERE name = ?1 and org_code=?2", nativeQuery = true)
	CatalogTree findOneByNameAndOrgCode(String name, String orgCode);	
	
	@Query(value = "select * from p_catalog_tree WHERE org_code=?1", nativeQuery = true)
	List<CatalogTree> findByOrgCode(String orgCode);
}