package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.tzs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.tzs.api.entity.DispatchTask;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.DispatchTaskServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchTaskDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

import static org.typroject.tyboot.core.foundation.context.RequestContext.getToken;

/**
 * 派遣任务
 *
 * @author system_generator
 * @date 2021-08-03
 */
@RestController
@Api(tags = "派遣任务Api")
@RequestMapping(value = "/tzs/dispatch-task")
public class DispatchTaskController extends BaseController {

    @Autowired
    DispatchTaskServiceImpl dispatchTaskServiceImpl;

	@Autowired
	RedisUtils redisUtils;

	/**
	 * 根据派遣单位类型和警情id 获取任务模板
	 * @param orgTypeCode
	 * @param alertId
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{orgTypeCode}/alert/{alertId}")
	@ApiOperation(httpMethod = "GET",value = "根据派遣单位类型和警情id 获取任务信息",  notes = "根据派遣单位类型和警情id 获取任务信息")
	public ResponseModel<DispatchTaskDto> selectOne(@PathVariable String orgTypeCode, @PathVariable Long alertId) {
		return ResponseHelper.buildResponse(dispatchTaskServiceImpl.getTaskInfo(orgTypeCode,alertId));
	}

    /**
     * 新增派遣任务
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增派遣任务", notes = "新增派遣任务")
	public ResponseModel<Boolean> save(@RequestBody DispatchTaskDto model) {
		ReginParams reginParams =
				JSONObject.parseObject(null != redisUtils.get(buildKey(getToken())) ?
						redisUtils.get(buildKey(getToken())).toString() : null, ReginParams.class);
		Boolean flag = dispatchTaskServiceImpl.createDispatchTask(model,reginParams.getUserModel());
	    return ResponseHelper.buildResponse(flag);
	}


    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个派遣任务",  notes = "根据sequenceNbr查询单个派遣任务")
	public ResponseModel<DispatchTaskDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(dispatchTaskServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
	 * 根据警情id 查找力量调派信息
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据警情id 查找力量调派信息",   notes = "根据警情id 查找力量调派信息")
	@GetMapping(value = "/list/alert/{alertId}")
	public ResponseModel<List<DispatchTask>> selectForListByAlertId(@PathVariable Long alertId) {
		QueryWrapper<DispatchTask> queryWrapper = new QueryWrapper<DispatchTask>();
		queryWrapper.eq("alert_id", alertId);
		List<DispatchTask> list = dispatchTaskServiceImpl.list(queryWrapper);
	    return ResponseHelper.buildResponse(list);
	}
}
