package com.yeejoin.amos.boot.module.common.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.common.api.dto.*;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;

import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;


/**
* 机构/部门/人员表 Mapper 接口
*
* @author tb
* @date 2021-06-18
*/
public interface OrgUsrMapper extends BaseMapper<OrgUsr> {
    String selectUpUnitByParam(@Param("id")String biz_org_code);
    
    int selectPersonListCount(Map<String, Object> map);

	List<Map<String, Object>> selectPersonList(Map<String, Object> map);

	List<OrgUsr> selectCompanyDepartmentMsg();

	List<Map<String, Object>> selectPersonAllList(Map<String, Object> map);

	List<OrgUsr> queryOrgUsrListByBizOrgCode(String bizOrgCode);

    List<OrgPersonExcelDto> queryOrgPersonDtoList(boolean isDelete);

    /**
     * 根据id查询当前单位下的所有子单位、部门
     *
     * @param orgUserId
     * @return
     */
    List<OrgUsr> listOrgUserById(Long orgUserId);

    /**
     * * @param null
     * @return
     * <PRE>
     * author tw
     * date 2021/7/20
     * </PRE>
     * 指挥重点单位资源
     */
    List<CompanyDto> listContractDto(@Param("pageNum")int pageNum, @Param("pageSize")int pageSize, @Param("par") RequestData par);

    Integer listContractDtoCount(@Param("par")RequestData par);
    /**
     * 获取机场单位树，包含对应单位下部门的数量
     * @return
     */
    List<OrgUsrTreeDto> getCompanyAndCountDepartment();


    List< OrgUsrzhDto> getOrgUsrzhDto(@Param("bizOrgName")String bizOrgName);


    List< Map<String,Object>> getparent();
    List< OrgUsrExcelDto> exportToExcel();

    /**
     * 查询单位基本信息列表和单位下所有的重点部位数量。
     */
    List<OrgUsrTreeDto> getCompanyAndKeySite(Long companyId);

    List<UserUnitDto>  getUserUnit(String id, String type, String code);
}
