package com.yeejoin.amos.boot.module.statistics.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.*;

@AllArgsConstructor
@Getter
public enum InformationManageTypeEnum {
    /**
     * 信息化管理情况枚举
     */
    TYPE_QR_CODE("1", "二维码"),
    TYPE_STAMP("2", "电子标签"),
    TYPE_OTHER("3", "其他"),
    TYPE_NO("99", "无");

    private String code;

    private String name;

    public static String getName(String code) {
        Optional<String> op = Arrays.stream(InformationManageTypeEnum.values()).filter(e -> e.getCode().equals(code)).map(InformationManageTypeEnum::getName).findFirst();
        return op.orElse("");
    }

    public static List<Map<String, Object>> getEnumList() {
        List<Map<String, Object>> list = new ArrayList<>();
        for (InformationManageTypeEnum testEnum : EnumSet.allOf(InformationManageTypeEnum.class)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("name", testEnum.name);
            map.put("code", testEnum.code);
            list.add(map);
        }
        return list;
    }


}
