package com.yeejoin.amos.boot.module.tzs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 警情接警填报记录
 *
 * @author litw
 * @date 2021-08-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="AlertCalledDto", description="警情接警填报记录")
public class AlertCalledDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "警情状态 (0 未结案 1 结案)")
    private Boolean alertStatus;

    @ApiModelProperty(value = "警情来源类型")
    private String alertSource;

    @ApiModelProperty(value = "接警时间")
    private Date callTime;

    @ApiModelProperty(value = "报警人电话")
    private String emergencyCall;

    @ApiModelProperty(value = "报警人名称，默认为先生或女士")
    private String emergencyPerson;

    @ApiModelProperty(value = "联系人姓名")
    private String contactUser;

    @ApiModelProperty(value = "联系人电话")
    private String contactPhone;

    @ApiModelProperty(value = "设备分类，字典表数据")
    private String equipmentClassification;

    @ApiModelProperty(value = "报警类型")
    private String type;

    @ApiModelProperty(value = "警情类别")
    private String alarmType;

    @ApiModelProperty(value = "通话记录信息id")
    private Integer callRecordId;

    @ApiModelProperty(value = "警情阶段")
    private String alertStage;

    @ApiModelProperty(value = "父警情id")
    private Long fatherAlert;

    @ApiModelProperty(value = "设备识别码")
    private String deviceId;

    @ApiModelProperty(value = "注册编码")
    private String registrationCode;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "设备分类code")
    private String equipmentClassificationCode;

    @ApiModelProperty(value = "报警类型code")
    private String typeCode;

    @ApiModelProperty(value = "警情类别code")
    private String alarmTypeCode;

    @ApiModelProperty(value = "警情阶段code")
    private String alertStageCode;

    @ApiModelProperty(value = "组织机构")
    private String orgCode;

}
