package com.yeejoin.amos.fas.business.controller;

import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.fas.business.service.intfc.IEvaModelService;
import com.yeejoin.amos.fas.config.Permission;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping("/api/fmeaEvaluate")
@Api("fmea评价模型api")
public class EvaModelController extends AbstractBaseController {
	@Autowired 
	IEvaModelService iEvaModelService;
	
	/**
	 * 评价模型查询
	 * @param id
	 * @return
	 */
	@Permission
	@ApiOperation(httpMethod = "GET",value = "fmea评价模型查询", notes = "fmea评价模型查询")
	@RequestMapping(value = "/list", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
	public CommonResponse queryEvaModel(@ApiParam(value = "查询条件", required = false) @RequestParam(value = "type",required =false) String type) {
		HashMap<String,Object> list = iEvaModelService.findFmeaByType(type);
		return CommonResponseUtil.success(list);
	}
	
}
