package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledDto;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.AlertCalledServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 警情接警填报记录
 *
 * @author litw
 * @date 2021-08-03
 */
@RestController
@Api(tags = "警情接警填报记录Api")
@RequestMapping(value = "/tzs/alert-called")
public class AlertCalledController extends BaseController {

    @Autowired
    AlertCalledServiceImpl alertCalledServiceImpl;

    /**
     * 新增警情接警填报记录
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增警情接警填报记录", notes = "新增警情接警填报记录")
	public ResponseModel<AlertCalledDto> save(@RequestBody AlertCalledDto model) {
	    model = alertCalledServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}


	/**
     * 根据id删除
     *
     * @param id 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{id}")
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除警情接警填报记录", notes = "根据id删除警情接警填报记录")
    public ResponseModel<Boolean> deleteByid(HttpServletRequest request, @PathVariable(value = "id") Long id){
		return ResponseHelper.buildResponse(alertCalledServiceImpl.removeById(id));
	}

    /**
     * 根据id查询
     *
	 * @param id  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{id}")
	@ApiOperation(httpMethod = "GET",value = "根据id查询单个警情接警填报记录",  notes = "根据id查询单个警情接警填报记录")
	public ResponseModel<AlertCalledDto> selectOne(@PathVariable Long id) {
	    return ResponseHelper.buildResponse(alertCalledServiceImpl.queryBySeq(id));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "警情接警填报记录分页查询",  notes = "警情接警填报记录分页查询")
	public ResponseModel<Page<AlertCalledDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<AlertCalledDto> page = new Page<AlertCalledDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(alertCalledServiceImpl.queryForAlertCalledPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "警情接警填报记录列表全部数据查询",   notes = "警情接警填报记录列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<AlertCalledDto>> selectForList() {
	    return ResponseHelper.buildResponse(alertCalledServiceImpl.queryForAlertCalledList());
	}
}
