package com.yeejoin.amos.boot.module.tzs.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.DispatchPaperServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchPaperDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 派遣单
 *
 * @author system_generator
 * @date 2021-08-03
 */
@RestController
@Api(tags = "派遣单Api")
@RequestMapping(value = "/tzs/dispatch-paper")
public class DispatchPaperController extends BaseController {

    @Autowired
    DispatchPaperServiceImpl dispatchPaperServiceImpl;

    /**
     * 新增派遣单
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增派遣单", notes = "新增派遣单")
	public ResponseModel<DispatchPaperDto> save(@RequestBody DispatchPaperDto model) {
	    model = dispatchPaperServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新派遣单", notes = "根据sequenceNbr更新派遣单")
	public ResponseModel<DispatchPaperDto> updateBySequenceNbrDispatchPaper(@RequestBody DispatchPaperDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(dispatchPaperServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除派遣单", notes = "根据sequenceNbr删除派遣单")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(dispatchPaperServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个派遣单",  notes = "根据sequenceNbr查询单个派遣单")
	public ResponseModel<DispatchPaperDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(dispatchPaperServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "派遣单分页查询",  notes = "派遣单分页查询")
	public ResponseModel<Page<DispatchPaperDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<DispatchPaperDto> page = new Page<DispatchPaperDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(dispatchPaperServiceImpl.queryForDispatchPaperPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "派遣单列表全部数据查询",   notes = "派遣单列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<DispatchPaperDto>> selectForList() {
	    return ResponseHelper.buildResponse(dispatchPaperServiceImpl.queryForDispatchPaperList());
	}
}
