package com.yeejoin.amos.boot.module.tzs.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.RepairConsultServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.RepairConsultDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 警情填报业务数据项
 *
 * @author system_generator
 * @date 2021-08-03
 */
@RestController
@Api(tags = "警情填报业务数据项Api")
@RequestMapping(value = "/tzs/repair-consult")
public class RepairConsultController extends BaseController {

    @Autowired
    RepairConsultServiceImpl repairConsultServiceImpl;

    /**
     * 新增警情填报业务数据项
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增警情填报业务数据项", notes = "新增警情填报业务数据项")
	public ResponseModel<RepairConsultDto> save(@RequestBody RepairConsultDto model) {
	    model = repairConsultServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新警情填报业务数据项", notes = "根据sequenceNbr更新警情填报业务数据项")
	public ResponseModel<RepairConsultDto> updateBySequenceNbrRepairConsult(@RequestBody RepairConsultDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(repairConsultServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除警情填报业务数据项", notes = "根据sequenceNbr删除警情填报业务数据项")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(repairConsultServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个警情填报业务数据项",  notes = "根据sequenceNbr查询单个警情填报业务数据项")
	public ResponseModel<RepairConsultDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(repairConsultServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "警情填报业务数据项分页查询",  notes = "警情填报业务数据项分页查询")
	public ResponseModel<Page<RepairConsultDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<RepairConsultDto> page = new Page<RepairConsultDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(repairConsultServiceImpl.queryForRepairConsultPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "警情填报业务数据项列表全部数据查询",   notes = "警情填报业务数据项列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<RepairConsultDto>> selectForList() {
	    return ResponseHelper.buildResponse(repairConsultServiceImpl.queryForRepairConsultList());
	}
}
