package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.equipmanage.common.utils.*;
import com.yeejoin.equipmanage.mapper.FireFightingSystemMapper;
import com.yeejoin.equipmanage.service.IEquipmentSpecificAlarmService;
import com.yeejoin.equipmanage.service.IFireFightingSystemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@Api(tags = "组态需求 -- API")
@RequestMapping(value = "/configure", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class ConfigureController extends AbstractBaseController {


    @Autowired
    private FireFightingSystemMapper fireFightingSystemMapper;

    @Autowired
    private IEquipmentSpecificAlarmService equipmentSpecificAlarmService;

    @Autowired
    private IFireFightingSystemService iFireFightingSystemService;

    @RequestMapping(value = "/alarmLogPage", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", produces = "application/json;charset=UTF-8", notes = "列表分页查询")
    public ResponseModel pageQuery(@RequestParam(required = false) String system, CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        ReginParams reginParams = getSelectedOrgInfo();
        List<CommonRequest> queryRequests = new ArrayList<>();
        CommonRequest request7 = new CommonRequest();
        request7.setName("system");
        request7.setValue(StringUtil.isNotEmpty(system) ? StringUtils.trimToNull(system) : null);
        queryRequests.add(request7);
        if (!ValidationUtil.isEmpty(reginParams.getPersonIdentity())) {
            CommonRequest request13 = new CommonRequest();
            request13.setName("bizOrgCode");
            request13.setValue(StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null);
            queryRequests.add(request13);
        }
        CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
        Page<Map<String, Object>> list = equipmentSpecificAlarmService.pageQuery(param);
        return CommonResponseUtil.success(list);
    }

    @RequestMapping(value = "/equipStatusCount", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "系统设备状态统计", produces = "application/json;charset=UTF-8", notes = "系统设备状态统计")
    public ResponseModel equipStatusCount(@RequestParam(required = false) String systemCode) {
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);
        }
        return CommonResponseUtil.success(equipmentSpecificAlarmService.equipStatusCount(hashMap));
    }

    @RequestMapping(value = "/equipAlarmLine", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "系统近一周告警趋势图", produces = "application/json;charset=UTF-8", notes = "系统近一周告警趋势图")
    public ResponseModel equipStatusCount(@RequestParam(required = false) String systemCode, @RequestParam(required = false) String indexKeys) {
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);
        }
        if (StringUtils.isNotBlank(indexKeys)) {
            hashMap.put("indexKeys", indexKeys.split(","));
        }
        return CommonResponseUtil.success(equipmentSpecificAlarmService.equipAlarmLine(hashMap));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取系统告警信息")
    @GetMapping("/getSystemAlarmInfo")
    public ResponseModel getSystemAlarmInfo(CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        if (StringUtils.isEmpty(bizOrgCode)) {
            return CommonResponseUtil.success(null);
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        return CommonResponseUtil.success(fireFightingSystemMapper.getSystemAlarmInfo(page, bizOrgCode));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取设备告警待确认和未处理信息（根据系统编码查询）")
    @GetMapping("/getEquipAlarmInfoNum")
    public ResponseModel getEquipAlarmInfoNum(@RequestParam(required = false) String systemCode) {
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        return CommonResponseUtil.success(fireFightingSystemMapper.getEquipAlarmInfoNum(systemCode, bizOrgCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取消防力量信息（队伍值班等）")
    @GetMapping("/getFireTeamInfo")
    public ResponseModel getFireTeamInfo() {
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        return CommonResponseUtil.success(fireFightingSystemMapper.getFireTeamInfo(bizOrgCode));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "消防车辆信息")
    @GetMapping("/getFireCarInfo")
    public ResponseModel getFireCarInfo() {
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        return CommonResponseUtil.success(fireFightingSystemMapper.getFireCarInfo(bizOrgCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "物联监控页面消防车辆信息")
    @GetMapping("/getFireCarInfoByWL")
    public ResponseModel getFireCarInfoByWL(CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        if (StringUtils.isEmpty(bizOrgCode)) {
            return CommonResponseUtil.success(null);
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        return CommonResponseUtil.success(fireFightingSystemMapper.getFireCarInfoByWL(page, "LSHLZ1bZAJU645Pgl7dMndrF"));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "概览水源信息")
    @GetMapping("/getWaterInfo")
    public ResponseModel getWaterInfo() {
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        return CommonResponseUtil.success(fireFightingSystemMapper.getWaterInfo(bizOrgCode, null));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "3小水源信息")
    @GetMapping("/getSmallWaterInfo")
    public ResponseModel getSmallWaterInfo(@RequestParam(required = false) String systemCode) {
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);

        }
        return CommonResponseUtil.success(iFireFightingSystemService.getSmallWaterInfo(hashMap));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "获取系统名称（根据系统编码查询）")
    @GetMapping("/getSystemName")
    public ResponseModel getEquipSystemName(@RequestParam(required = false) String systemCode) {
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.getSystemName(hashMap));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "获取系统工作状态（根据系统编码查询）")
    @GetMapping("/getSystemStatus")
    public ResponseModel getEquipSystemStatus(@RequestParam(required = false) String systemCode) {
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.getSystemStatus(hashMap));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取系统近一月告警设备top5（根据系统编码查询）")
    @GetMapping("/getAlarmOneMonth")
    public ResponseModel getSpecificAlarmOneMonthTOP(@RequestParam(required = false) String systemCode) {
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.equipAlarmTOP(hashMap));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取系统设备状态（根据系统编码查询）")
    @GetMapping("/getEquipmentState")
    public ResponseModel getEquipmentState(@RequestParam(required = false) String systemCode, CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        Page result = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.equipmentState(result, hashMap));
    }

}
