package com.yeejoin.amos.boot.module.cylinder.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.typroject.tyboot.core.rdbms.model.BaseModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 气瓶充装统计表-企业-以天为维度
 *
 * @author system_generator
 * @date 2024-06-05
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="CylinderFillingRecordStatisticsUnitDayModel", description="气瓶充装统计表-企业-以天为维度")
public class CylinderFillingRecordStatisticsUnitDayDto extends BaseModel {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "充装次数")
    private Integer totalSum;

    @ApiModelProperty(value = "充装前检查数量")
    private Integer fillingBeforeSum;

    @ApiModelProperty(value = "充装后检查数量")
    private Integer fillingAfterSum;

    @ApiModelProperty(value = "企业编码")
    private String appId;

    @ApiModelProperty(value = "区域编码")
    private String regionCode;

    @ApiModelProperty(value = "充装日期")
    private Date fillingDate;

    @ApiModelProperty(value = "充装检查不合格数")
    private int fillingNotPassedCount;

    @ApiModelProperty(value = "累计充装量")
    private BigDecimal fillingQuantity;

}
