package com.yeejoin.amos.boot.module.cylinder.api.entity;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 用户资质信息表
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_user_qualifications")
public class TzsUserQualifications extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 证书类型
     */
    @TableField("certificate_type")
    private String certificateType;

    /**
     * 证书编号
     */
    @TableField("certificate_num")
    private String certificateNum;

    /**
     * 发证机关
     */
    @TableField("issuing_unit")
    private String issuingUnit;

    /**
     * 作业项目id
     */
    @TableField("project_id")
    private String projectId;

    /**
     * 发证日期
     */
    @TableField("issuing_date")
    private Date issuingDate;

    /**
     * 有效期
     */
    @TableField("expiration_date")
    private String expirationDate;

    /**
     * 附件
     */
    @TableField("file")
    private String file;

    /**
     * 用户信息id
     */
    @TableField("user_info_id")
    private String userInfoId;
}
