package com.yeejoin.amos.boot.module.cylinder.flc.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeejoin.amos.boot.module.common.api.constant.TZSCommonConstant;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.common.api.enums.ReginStepEnum;
import com.yeejoin.amos.boot.module.cylinder.api.dto.KeyValueDto;
import com.yeejoin.amos.boot.module.cylinder.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.cylinder.api.entity.ESCylinderFillingRecordDto;
import com.yeejoin.amos.boot.module.cylinder.api.service.ITzBaseEnterpriseInfoService;
import com.yeejoin.amos.boot.module.cylinder.biz.dao.ESCylinderFillingRecordRepository;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CityCylinderInfoDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderAreaDataDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.entity.CylinderAreaData;
import com.yeejoin.amos.boot.module.cylinder.flc.api.mapper.CylinderAreaDataMapper;
import com.yeejoin.amos.boot.module.cylinder.flc.api.service.ICylinderAreaDataService;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import joptsimple.internal.Strings;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 气瓶区域统计表服务实现类
 *
 * @author system_generator
 * @date 2022-03-08
 */
@Service
public class CylinderAreaDataServiceImpl extends BaseService<CylinderAreaDataDto, CylinderAreaData, CylinderAreaDataMapper> implements ICylinderAreaDataService {

    public final static String LICENSE_IS_OK = "正常";

    public final static String NO_DATA_STR = "--";

    @Autowired
    RestHighLevelClient restHighLevelClient;

    @Autowired
    ESCylinderFillingRecordRepository esCylinderFillingRecordRepository;

    @Autowired
    ITzBaseEnterpriseInfoService iTzBaseEnterpriseInfoService;
    /**
     * 分页查询
     */
    public Page<CylinderAreaDataDto> queryForCylinderAreaDataPage(Page<CylinderAreaDataDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<CylinderAreaDataDto> queryForCylinderAreaDataList() {
        return this.queryForList("", false);
    }

    public List<CityCylinderInfoDto> getCityCylinderData(String level) {
        return this.queryForList("", false, level).stream()
                .map(v -> CityCylinderInfoDto.builder()
                        .regionName(v.getAreaName())
                        .regionCode(v.getRegionCode())
                        .longitude(v.getLongitude())
                        .latitude(v.getLatitude())
                        .isAlarm(v.getOutOfDateNum() != 0)
                        .cylindersCount(v.getCylinderNum())
                        .stationCount(v.getUnitNum())
                        .build())
                .collect(Collectors.toList());
    }

    public Page<Map<String, Object>> getEarlyWarningStatistics(String regionCode, String appId) {
        Page<Map<String, Object>> page = new Page<>();
        // 是否有充装企业在指定区域下
        Boolean isHavingUnitInRegion = true;
        List<Map<String, Object>> list = Lists.newArrayList();
        Map<String, Object> result1 = Maps.newHashMap();
        Map<String, Object> result2 = Maps.newHashMap();
        // 1.许可有效率
        if (!ValidationUtil.isEmpty(appId)) {
            result1.put("name", "许可有效期");
            result1.put("value", this.getBaseMapper().queryLicenseEfficiencyOneCompany(appId).getStrValue());
        } else if (!ValidationUtil.isEmpty(regionCode)) {
            result1.put("name", "许可有效率(%)");
            result1.put("value", this.getLicenseEfficiencyByRegion(regionCode));
            isHavingUnitInRegion = this.setNoUnitDataStaticInfo(list, result1.get("value").toString());
        }
        if (!ValidationUtil.isEmpty(regionCode) && !isHavingUnitInRegion) {
            return page.setRecords(list);
        }
        // 2.使用登记办理率
        if (!ValidationUtil.isEmpty(appId)) {
            result2.put("name", "使用登记");
            result2.put("value", "已办理");
        } else {
            result2.put("name", "使用登记办理率(%)");
            result2.put("value", "100");
        }
        // 3.检验超期率
        Map<String, Object> result3 = Maps.newHashMap();
        result3.put("name", "检验超期率(%)");
        result3.put("value", this.getBaseMapper().getInspectionExpiredRate(regionCode, appId).get("expiredRate").toString());
        // 4.检验合格率
        Map<String, Object> result4 = Maps.newHashMap();
        result4.put("name", "检验合格率(%)");
        result4.put("value", this.getBaseMapper().getInspectionResultRate(regionCode, appId).get("resultRate").toString());
        // 5.充装检查率
        Map<String, Object> result5 = Maps.newHashMap();
        long totalAll = searchEsCount(false, false, regionCode, appId);
        long totalCheck = searchEsCount(true, false, regionCode, appId);
        long totalResult = searchEsCount(false, true, regionCode, appId);
        result5.put("name", "充装检查率(%)");
        if (totalAll != 0) {
            result5.put("value", new DecimalFormat("#.00").format(((double) totalCheck / totalAll) * 100));
        } else {
            result5.put("value", 0);
        }
        // 6.充装检查合格率
        Map<String, Object> result6 = Maps.newHashMap();
        result6.put("name", "充装检查合格率(%)");
        if (totalAll != 0) {
            result6.put("value", new DecimalFormat("#.00").format(((double) totalResult / totalAll) * 100));
        } else {
            result6.put("value", 0);
        }

        // list中按以下固定顺序返回给前端
        list.add(result1);
        list.add(result3);
        list.add(result5);
        list.add(result2);
        list.add(result4);
        list.add(result6);
        page.setRecords(list);
        return page;
    }

    private Boolean setNoUnitDataStaticInfo(List<Map<String, Object>> list, String value) {
        if (NO_DATA_STR.equals(value)) {
            Map<String, Object> result2 = Maps.newHashMap();
            result2.put("name", "使用登记办理率(%)");
            result2.put("value", NO_DATA_STR);
            Map<String, Object> result3 = Maps.newHashMap();
            result3.put("name", "检验超期率(%)");
            result3.put("value", NO_DATA_STR);
            Map<String, Object> result4 = Maps.newHashMap();
            result4.put("name", "检验合格率(%)");
            result4.put("value", NO_DATA_STR);
            Map<String, Object> result5 = Maps.newHashMap();
            result5.put("name", "充装检查率(%)");
            result5.put("value", NO_DATA_STR);
            Map<String, Object> result6 = Maps.newHashMap();
            result6.put("name", "充装检查合格率(%)");
            result6.put("value", NO_DATA_STR);
            list.add(result2);
            list.add(result3);
            list.add(result5);
            list.add(result4);
            list.add(result6);
            return false;
        }
        return true;
    }

    private String getLicenseEfficiencyByRegion(String regionCode) {
        List<KeyValueDto> keyValueDtos = this.getBaseMapper().queryLicenseEfficiencyOfRegion(regionCode);
        int totalUnitNumber = keyValueDtos.stream().mapToInt(KeyValueDto::getIValue).sum();
        int okUnitNumberNumber = keyValueDtos.stream().filter(k -> k.getStrKey().equals(LICENSE_IS_OK)).mapToInt(KeyValueDto::getIValue).sum();
        if (totalUnitNumber == 0) {
            return NO_DATA_STR;
        }
        BigDecimal bigTotalUnitNumber = new BigDecimal(String.valueOf(totalUnitNumber));
        BigDecimal bigOkUnitNumberNumber = new BigDecimal(String.valueOf(okUnitNumberNumber));
        BigDecimal result = bigOkUnitNumberNumber.divide(bigTotalUnitNumber, 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2);
        return result.toPlainString();
    }

    private long searchEsCount(Boolean checkOk, Boolean resultOk, String regionCode, String appId) {
        CountRequest countRequest = new CountRequest("cylinder_filling");
//        countRequest.indices("cylinder_filling");
        BoolQueryBuilder boolMust = QueryBuilders.boolQuery();
        if (checkOk) {
            //匹配充装前检查和充装后检查都有数据
            BoolQueryBuilder meBuilder = QueryBuilders.boolQuery();
            meBuilder.must(QueryBuilders.existsQuery("inspectionDateMs"));
            meBuilder.must(QueryBuilders.existsQuery("inspectionDateAfterMS"));
            boolMust.must(meBuilder);
        }
        if (resultOk) {
            //匹配充装前检查和充装后检查都有数据
            BoolQueryBuilder meBuilder = QueryBuilders.boolQuery();
            meBuilder.must(QueryBuilders.termQuery("fillingResult.keyword", "合格"));
            meBuilder.must(QueryBuilders.termQuery("checkResult.keyword", "合格"));
            boolMust.must(meBuilder);
        }

        //匹配行政区划
        if (!ObjectUtils.isEmpty(regionCode)) {
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.must(QueryBuilders.wildcardQuery("regionCode", "*" + regionCode + "*"));
            boolMust.must(query);
        }
        //匹配appId
        if (!ObjectUtils.isEmpty(appId)) {
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.must(QueryBuilders.matchQuery("appId", appId));
            boolMust.must(query);
        }

        countRequest.query(boolMust);
        try {
            CountResponse countResponse = restHighLevelClient.count(countRequest, RequestOptions.DEFAULT);
            return countResponse.getCount();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String testSaveCylinderFillingRecord2ES() {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices("cylinder_filling");
        List<ESCylinderFillingRecordDto> dtoList = Lists.newArrayList();
        ESCylinderFillingRecordDto esCylinderFillingRecordDto = new ESCylinderFillingRecordDto();
        esCylinderFillingRecordDto.setAppId("1");
        esCylinderFillingRecordDto.setCreditCode("1");
        esCylinderFillingRecordDto.setCheckResult("合格");
        esCylinderFillingRecordDto.setFillingResult("合格");
        esCylinderFillingRecordDto.setUnitName("1test1");
        dtoList.add(esCylinderFillingRecordDto);
        ESCylinderFillingRecordDto esCylinderFillingRecordDto1 = new ESCylinderFillingRecordDto();
        esCylinderFillingRecordDto1.setAppId("1");
        esCylinderFillingRecordDto1.setCreditCode("1");
        esCylinderFillingRecordDto1.setCheckResult("合格");
        esCylinderFillingRecordDto1.setFillingResult("合格");
        esCylinderFillingRecordDto1.setUnitName("1test1");
        dtoList.add(esCylinderFillingRecordDto1);
        esCylinderFillingRecordRepository.saveAll(dtoList);
        return "success";
    }



    public List<Map<String, Object>> getCylinderStatisticsData(String regionCode) throws IOException {
        // 构建搜索请求
        CompanyModel result = Privilege.companyClient.queryByCompanyCode(regionCode).getResult();
        String orgCode = result.getOrgCode();
        SearchRequest searchRequest = new SearchRequest("idx_biz_view_jg_all"); // 替换为你的索引名
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();

        // 构建查询条件
        searchSourceBuilder.query(
                QueryBuilders.boolQuery()
                        .must(QueryBuilders.termQuery("EQU_CATEGORY_CODE", "2300"))
                        .must(QueryBuilders.matchPhraseQuery("ORG_BRANCH_CODE", orgCode)) // 假设你只匹配以50开头的ORG_BRANCH_CODE
        );

        TermsAggregationBuilder aggregation = AggregationBuilders.terms("USE_UNIT_CREDIT_CODE").field("USE_UNIT_CREDIT_CODE.keyword").size(10); // 注意：.keyword后缀可能根据你的字段映射而有所不同

        searchSourceBuilder.aggregation(aggregation);
        searchRequest.source(searchSourceBuilder);

        // 执行搜索并获取响应
        SearchResponse searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);

        // 处理聚合结果
        // 这里只是打印出聚合的名称和桶的数量，你需要根据自己的需求来处理这些数据
        Terms terms = searchResponse.getAggregations().get("USE_UNIT_CREDIT_CODE");
        List<Map<String, Object>> dataList = new ArrayList<>();
        List<String> keys = new ArrayList<>();
        for (Terms.Bucket bucket : terms.getBuckets()) {
            Map<String, Object> item = new HashMap<>();
            item.put("count", bucket.getDocCount());
            item.put("key", bucket.getKeyAsString());
            dataList.add(item);
            keys.add(bucket.getKeyAsString());
        }

        List<TzBaseEnterpriseInfoDto> tzBaseEnterpriseInfoDtos = iTzBaseEnterpriseInfoService.queryByUseCode(keys);
        Map<String, TzBaseEnterpriseInfoDto> collect = tzBaseEnterpriseInfoDtos.stream().collect(Collectors.toMap(TzBaseEnterpriseInfoDto::getUseCode, f -> f));
        for (Map<String, Object> item : dataList) {
            Object key = item.get("key");
            if (collect.containsKey(key)) {
                item.put("name", collect.get(key).getUseUnit());
                item.put("city", collect.get(key).getCity());
                item.put("province", collect.get(key).getProvince());
                item.put("district", collect.get(key).getDistrict());
            }
        }
        return dataList;
    }

    public Map<String, Object> getChildEarlyWarning(String regionCode) throws Exception {
        List<RegionModel> regionModels = this.setRegionIfRootParent(regionCode);
        List<String> collect = regionModels.stream().map(c -> c.getRegionCode().toString()).collect(Collectors.toList());
        List<CompanyModel> companyModelList = Privilege.companyClient.queryListByCompanyCode(Strings.join(collect, ",")).getResult();
        Map<String, CompanyModel> companyMap = companyModelList.stream().collect(Collectors.toMap(CompanyModel::getCompanyCode, c -> c));

        Set<String> legendData = new HashSet<>();
        List<String> xdata = new ArrayList<>();
        List<String> xuke = new ArrayList<>();
        List<String> shiyongdengji = new ArrayList<>();
        List<String> jianyanchaoqi = new ArrayList<>();
        List<String> jianyanhege = new ArrayList<>();
        List<String> czjc = new ArrayList<>();
        List<String> czjchege = new ArrayList<>();
//        List<String> renyuan = new ArrayList<>();

        legendData.add("许可有效率");
        legendData.add("使用登记办理率");
        legendData.add("检验超期率");
        legendData.add("检验合格率");
        legendData.add("充装检查率");
        legendData.add("充装检查合格率");

        for (RegionModel region : regionModels) {

            CompanyModel companyModel = companyMap.get(region.getRegionCode().toString());
            if (ObjectUtils.isEmpty(companyModel)) {
                continue;
            }
            // 是否有充装企业在指定区域下
            Boolean isHavingUnitInRegion = true;
            String orgCode = companyModel.getOrgCode();

            xdata.add(region.getRegionName());
            // 1.许可有效率
            if (!ValidationUtil.isEmpty(companyModel)) {
                String value = this.getLicenseEfficiencyByRegion(orgCode);
                if (NO_DATA_STR.equals(value)) {
                    xuke.add("0");
                } else {
                    xuke.add(String.format("%.4f", Double.parseDouble(value) / 100.0000 ));
                }
            }
            if (!ValidationUtil.isEmpty(orgCode) && !isHavingUnitInRegion) {
                shiyongdengji.add("0");
                jianyanchaoqi.add("0");
                jianyanhege.add("0");shiyongdengji.add("0");
                czjc.add("0");
                czjchege.add("0");
                continue;
            }
            // 2.使用登记办理率
            shiyongdengji.add("1");
            // 3.检验超期率
            jianyanchaoqi.add(String.format("%.4f", Double.parseDouble(this.getBaseMapper().getInspectionExpiredRate(orgCode, null).get("expiredRate").toString()) / 100.0000));
            // 4.检验合格率
            jianyanhege.add(String.format("%.4f", Double.parseDouble(this.getBaseMapper().getInspectionResultRate(orgCode, null).get("resultRate").toString()) / 100.0000));
            // 5.充装检查率
            long totalAll = searchEsCount(false, false, orgCode, null);
            long totalCheck = searchEsCount(true, false, orgCode, null);
            long totalResult = searchEsCount(false, true, orgCode, null);
            if (totalAll != 0) {
                czjc.add(new DecimalFormat("#.0000").format(((double) totalCheck / totalAll)));
            } else {
                czjc.add("0");
            }
            // 6.充装检查合格率
            if (totalAll != 0) {
                czjchege.add(new DecimalFormat("#.0000").format(((double) totalResult / totalAll)));
            } else {
                czjchege.add("0");
            }
        }
        Map<String, Object> result = new HashMap<>();

        result.put("xdata", xdata);
        result.put("legendData", legendData);
        result.put("xuke", xuke);
        result.put("shiyongdengji", shiyongdengji);
        result.put("jianyanchaoqi", jianyanchaoqi);
        result.put("jianyanhege", jianyanhege);
        result.put("czjc", czjc);
        result.put("czjchege", czjchege);

        return result;
    }

    public Map getChildWarning(String regionCode) {
        Map<String, Object> result = Maps.newHashMap();
        // 是否有充装企业在指定区域下
        Boolean isHavingUnitInRegion = true;
        List<Map<String, Object>> list = Lists.newArrayList();
        Map<String, Object> result1 = Maps.newHashMap();
        Map<String, Object> result2 = Maps.newHashMap();

        // 1.许可有效率
        if (!ValidationUtil.isEmpty(regionCode)) {
            result1.put("name", "许可有效率(%)");
            result1.put("value", this.getLicenseEfficiencyByRegion(regionCode));
            isHavingUnitInRegion = this.setNoUnitDataStaticInfo(list, result1.get("value").toString());
        }
        if (!ValidationUtil.isEmpty(regionCode) && !isHavingUnitInRegion) {
            list.add(result1);
            result.put(regionCode, list);
            return result;
        }
        // 2.使用登记办理率
        result2.put("name", "使用登记办理率(%)");
        result2.put("value", "100");
        // 3.检验超期率
        Map<String, Object> result3 = Maps.newHashMap();
        result3.put("name", "检验超期率(%)");
        result3.put("value", this.getBaseMapper().getInspectionExpiredRate(regionCode, null).get("expiredRate").toString());
        // 4.检验合格率
        Map<String, Object> result4 = Maps.newHashMap();
        result4.put("name", "检验合格率(%)");
        result4.put("value", this.getBaseMapper().getInspectionResultRate(regionCode, null).get("resultRate").toString());
        // 5.充装检查率
        Map<String, Object> result5 = Maps.newHashMap();
        long totalAll = searchEsCount(false, false, regionCode, null);
        long totalCheck = searchEsCount(true, false, regionCode, null);
        long totalResult = searchEsCount(false, true, regionCode, null);
        result5.put("name", "充装检查率(%)");
        if (totalAll != 0) {
            result5.put("value", new DecimalFormat("#.00").format(((double) totalCheck / totalAll) * 100));
        } else {
            result5.put("value", 0);
        }
        // 6.充装检查合格率
        Map<String, Object> result6 = Maps.newHashMap();
        result6.put("name", "充装检查合格率(%)");
        if (totalAll != 0) {
            result6.put("value", new DecimalFormat("#.00").format(((double) totalResult / totalAll) * 100));
        } else {
            result6.put("value", 0);
        }

        // list中按以下固定顺序返回给前端
        list.add(result1);
        list.add(result3);
        list.add(result5);
        list.add(result2);
        list.add(result4);
        list.add(result6);

        result.put(regionCode, list);
        return result;
    }

    public Map<String, Object> getCylinderStatisticsDataByCity(String regionCode) throws Exception {
        // 构建搜索请求
        List<RegionModel> regionList = this.setRegionIfRootParent(regionCode);
        List<String> companyCode = regionList.stream().map(r -> r.getRegionCode().toString()).collect(Collectors.toList());
        List<CompanyModel> companyList = Privilege.companyClient.queryListByCompanyCode(String.join(",", companyCode)).getResult();
        Map<String, RegionModel> regionMap = regionList.stream().collect(Collectors.toMap(r ->r.getRegionCode().toString(), r -> r));
        List<Map<String, Object>> legendData = new ArrayList<>();
        List<String>  xdata = new ArrayList<>();
        List<String>  qiping = new ArrayList<>();
        List<String>  qizhan = new ArrayList<>();

        long maxValue = 0;

        for (CompanyModel comapany : companyList) {
            String orgCode = comapany.getOrgCode();
            xdata.add(regionMap.get(comapany.getCompanyCode()).getRegionName());
            SearchRequest searchRequest = new SearchRequest("idx_biz_view_jg_all"); // 替换为你的索引名
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();

            // 构建查询条件
            searchSourceBuilder.query(
                    QueryBuilders.boolQuery()
                            .must(QueryBuilders.termQuery("EQU_CATEGORY_CODE", "2300"))
                            .must(QueryBuilders.matchPhraseQuery("ORG_BRANCH_CODE", orgCode)) // 假设你只匹配以50开头的ORG_BRANCH_CODE
            );

            TermsAggregationBuilder aggregation = AggregationBuilders.terms("ORG_BRANCH_CODE").field("ORG_BRANCH_CODE.keyword").size(10); // 注意：.keyword后缀可能根据你的字段映射而有所不同

            searchSourceBuilder.aggregation(aggregation);
            searchRequest.source(searchSourceBuilder);

            // 执行搜索并获取响应
            SearchResponse searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            // 处理聚合结果
            // 这里只是打印出聚合的名称和桶的数量，你需要根据自己的需求来处理这些数据
            Terms terms = searchResponse.getAggregations().get("ORG_BRANCH_CODE");
            if (!ObjectUtils.isEmpty(terms.getBuckets())) {
                if (terms.getBuckets().get(0).getDocCount() > maxValue) {
                    maxValue = terms.getBuckets().get(0).getDocCount();
                }
                qiping.add( terms.getBuckets().get(0).getDocCount() + "");
            } else {
                qiping.add( "0");
            }
        }

        if (maxValue > 100000) {
            for (int i = 0; i < qiping.size(); i++) {
                qiping.set(i, String.format("%.4f", Long.parseLong(qiping.get(i)) / 10000.0000) + "");
            }
        }

        List<String> orgCodes = companyList.stream().map(c -> c.getOrgCode()).collect(Collectors.toList());
        List<Map<String, Object>> qizhanMap = this.baseMapper.getQiZhanStatisticsDataByCity(orgCodes);
        Map<Object, Object> collect = qizhanMap.stream().collect(Collectors.toMap(m -> ((Map) m).get("orgCode"), m -> ((Map) m).get("unitCount")));
        for (CompanyModel comapany : companyList) {
            String orgCode = comapany.getOrgCode();
            if (collect.containsKey(orgCode)) {
                qizhan.add(collect.get(orgCode).toString());
            } else {
                qizhan.add("0");
            }
        }

        Map<String, Object> qiLegend = new HashMap<>();
        if (maxValue > 100000) {
            qiLegend.put("value", "气瓶数量(万)");
            qiLegend.put("dataKey", "qiping");
        } else {
            qiLegend.put("value", "气瓶数量");
            qiLegend.put("dataKey", "qiping");
        }

        Map<String, Object> zhanLegend = new HashMap<>();
        zhanLegend.put("value", "气站数量");
        zhanLegend.put("dataKey", "qizhan");

        legendData.add(qiLegend);
        legendData.add(zhanLegend);

        Map<String, Object> result = new HashMap<>();
        result.put("qizhan", qizhan);
        result.put("qiping", qiping);
        result.put("xdata", xdata);
        result.put("legendData", legendData);
        return result;
    }

    private List<RegionModel> setRegionIfRootParent(String regionCode) throws Exception {
        List<RegionModel> regionList = Systemctl.regionClient.queryByParentRegionCode(Integer.parseInt(regionCode)).getResult();
        // 陕西省时需要在地图返回独立的地级市:韩城、杨凌、西咸
        if (regionCode.equals(TZSCommonConstant.SHAN_XI_REGION_CODE)) {
            List<RegionModel> independentRegions = ReginStepEnum.enum2RegionList("map");
            regionList.addAll(independentRegions);
        }
        return regionList;
    }

    public Map<String, Object> getCylinderStatisticsDataByCityForTotal(String regionCode) throws IOException {
        // 构建搜索请求
        CompanyModel comapany = Privilege.companyClient.queryByCompanyCode(regionCode).getResult();
        String orgCode = comapany.getOrgCode();
        SearchRequest searchRequest = new SearchRequest("idx_biz_view_jg_all"); // 替换为你的索引名
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        long qiping = 0;
        // 构建查询条件
        searchSourceBuilder.query(
                QueryBuilders.boolQuery()
                        .must(QueryBuilders.termQuery("EQU_CATEGORY_CODE", "2300"))
                        .must(QueryBuilders.matchPhraseQuery("ORG_BRANCH_CODE", orgCode)) // 假设你只匹配以50开头的ORG_BRANCH_CODE
        );

        TermsAggregationBuilder aggregation = AggregationBuilders.terms("ORG_BRANCH_CODE").field("ORG_BRANCH_CODE.keyword").size(10); // 注意：.keyword后缀可能根据你的字段映射而有所不同

        searchSourceBuilder.aggregation(aggregation);
        searchRequest.source(searchSourceBuilder);

        // 执行搜索并获取响应
        SearchResponse searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        // 处理聚合结果
        // 这里只是打印出聚合的名称和桶的数量，你需要根据自己的需求来处理这些数据
        Terms terms = searchResponse.getAggregations().get("ORG_BRANCH_CODE");
        if (!ObjectUtils.isEmpty(terms.getBuckets())) {
            qiping = terms.getBuckets().get(0).getDocCount() ;
        } else {
            qiping = 0;
        }

        List<String> orgCodes = new ArrayList<>();
        orgCodes.add(orgCode);
        List<Map<String, Object>> qizhanMap = this.baseMapper.getQiZhanStatisticsDataByCity(orgCodes);
        String unitNumber = "0";
        if (!ObjectUtils.isEmpty(qizhanMap)) {
            unitNumber = qizhanMap.get(0).get("unitCount").toString();
        }

        Map<String, Object> result = new HashMap<>();
        result.put("cylindersCount", qiping);
        result.put("stationCount", unitNumber);
        result.put("operatorCount", this.baseMapper.getOpertorStatisticsDataByCity(orgCodes));
        return result;
    }

    public List<Map<String, Object>> getCylinderStatisticsDataByCityForMap(String regionCode) throws Exception {
        // 构建搜索请求
        List<RegionModel> regionList = this.setRegionIfRootParent(regionCode);
        List<String> companyCode = regionList.stream().map(r -> r.getRegionCode().toString()).collect(Collectors.toList());
        List<CompanyModel> companyList = Privilege.companyClient.queryListByCompanyCode(String.join(",", companyCode)).getResult();
        Map<String, RegionModel> regionMap = regionList.stream().collect(Collectors.toMap(r ->r.getRegionCode().toString(), r -> r));
        List<Map<String, Object>> list = new ArrayList<>();
        if (ObjectUtils.isEmpty(companyList)) {
            return new ArrayList<>();
        }
        List<String> orgCodes = companyList.stream().map(CompanyModel::getOrgCode).collect(Collectors.toList());
        List<Map<String, Object>> qizhanMap = this.baseMapper.getQiZhanStatisticsDataByCity(orgCodes);
        Map<Object, Object> collect = qizhanMap.stream().collect(Collectors.toMap(m -> ((Map) m).get("orgCode"), m -> ((Map) m).get("unitCount")));

        for (CompanyModel company : companyList) {
            String orgCode = company.getOrgCode();
            SearchRequest searchRequest = new SearchRequest("idx_biz_view_jg_all"); // 替换为你的索引名
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            long qiping = 0;
            // 构建查询条件
            searchSourceBuilder.query(
                    QueryBuilders.boolQuery()
                            .must(QueryBuilders.termQuery("EQU_CATEGORY_CODE", "2300"))
                            .must(QueryBuilders.matchPhraseQuery("ORG_BRANCH_CODE", orgCode)) // 假设你只匹配以50开头的ORG_BRANCH_CODE
            );

            TermsAggregationBuilder aggregation = AggregationBuilders.terms("ORG_BRANCH_CODE").field("ORG_BRANCH_CODE.keyword").size(10); // 注意：.keyword后缀可能根据你的字段映射而有所不同

            searchSourceBuilder.aggregation(aggregation);
            searchRequest.source(searchSourceBuilder);

            // 执行搜索并获取响应
            SearchResponse searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            // 处理聚合结果
            // 这里只是打印出聚合的名称和桶的数量，你需要根据自己的需求来处理这些数据
            Terms terms = searchResponse.getAggregations().get("ORG_BRANCH_CODE");
            if (!ObjectUtils.isEmpty(terms.getBuckets())) {
                qiping = terms.getBuckets().get(0).getDocCount() ;
            } else {
                qiping = 0;
            }

            String unitNumber = "0";
            if (!ObjectUtils.isEmpty(collect) && collect.containsKey("orgCode")) {
                unitNumber = collect.get("orgCode").toString();
            }

            Map<String, Object> result = new HashMap<>();

            RegionModel region = regionMap.get(company.getCompanyCode());
            result.put("regionAddress", company.getAddress());
            result.put("regionCode", company.getCompanyCode());
            result.put("regionName", region.getRegionName());
            result.put("longitude", company.getLongitude());
            result.put("latitude", company.getLatitude());
            result.put("stationCount", unitNumber);
            result.put("cylindersCount", qiping);
            result.put("operatorCount", 0);

            list.add(result);
        }

        return list;
    }


    public Map<String, Object> getsecurityIndex(String regionCode) throws Exception {
        List<RegionModel> regionModels = this.setRegionIfRootParent(regionCode);
        List<String> collect = regionModels.stream().map(c -> c.getRegionCode().toString()).collect(Collectors.toList());
        List<CompanyModel> companyModelList = Privilege.companyClient.queryListByCompanyCode(Strings.join(collect, ",")).getResult();
        Map<String, CompanyModel> companyMap = companyModelList.stream().collect(Collectors.toMap(CompanyModel::getCompanyCode, c -> c));

        List<String> xdata = new ArrayList<>();
        List<String> xuke = new ArrayList<>();
        List<String> shiyongdengji = new ArrayList<>();
        List<String> jianyanchaoqi = new ArrayList<>();
        List<String> jianyanhege = new ArrayList<>();
        List<String> czjc = new ArrayList<>();
        List<String> czjchege = new ArrayList<>();

        for (RegionModel region : regionModels) {

            CompanyModel companyModel = companyMap.get(region.getRegionCode().toString());
            if (ObjectUtils.isEmpty(companyModel)) {
                continue;
            }
            // 是否有充装企业在指定区域下
            Boolean isHavingUnitInRegion = true;
            String orgCode = companyModel.getOrgCode();

            xdata.add(region.getRegionName());
            // 1.许可有效率
            if (!ValidationUtil.isEmpty(companyModel)) {
                String value = this.getLicenseEfficiencyByRegion(orgCode);
                if (NO_DATA_STR.equals(value)) {
                    value = "0";
                    xuke.add(value);
                } else {
                    xuke.add(value);
                }
            }
            if (!ValidationUtil.isEmpty(orgCode) && !isHavingUnitInRegion) {
                shiyongdengji.add("0");
                jianyanchaoqi.add("0");
                jianyanhege.add("0");shiyongdengji.add("0");
                czjc.add("0");
                czjchege.add("0");
                continue;
            }
            // 2.使用登记办理率
            shiyongdengji.add("100");
            // 3.检验超期率
            jianyanchaoqi.add(this.getBaseMapper().getInspectionExpiredRate(orgCode, null).get("expiredRate").toString());
            // 4.检验合格率
            jianyanhege.add(this.getBaseMapper().getInspectionResultRate(orgCode, null).get("resultRate").toString());
            // 5.充装检查率
            long totalAll = searchEsCount(false, false, orgCode, null);
            long totalCheck = searchEsCount(true, false, orgCode, null);
            long totalResult = searchEsCount(false, true, orgCode, null);
            if (totalAll != 0) {
                czjc.add(new DecimalFormat("#.00").format(((double) totalCheck / totalAll) * 100));
            } else {
                czjc.add("0");
            }
            // 6.充装检查合格率
            if (totalAll != 0) {
                czjchege.add(new DecimalFormat("#.00").format(((double) totalResult / totalAll) * 100));
            } else {
                czjchege.add("0");
            }
        }
        Map<String, Object> result = new HashMap<>();

        List<Map<String, String>> data = new ArrayList<>();

//        List<String> ydata = new ArrayList<>();
        for (int i = 0; i < xdata.size(); i++) {
            Map<String, String> item = new HashMap<>();
            item.put("name", xdata.get(i));

            // 计算xuke的加权值
            double xukeWeighted = Double.parseDouble(xuke.get(i)) * 0.10; // 10%

            // 剩余权重平均分配给四个因素，每个因素大约22.5%（但为了简化，我们这里用25%的剩余权重）
            double remainingWeightPerFactor = 0.90 / 4; // 简化为每个因素25%的剩余权重

            // 计算其他四个因素的加权值
            double jianyanchaoqiWeighted = Double.parseDouble(jianyanchaoqi.get(i))  * remainingWeightPerFactor;
            double jianyanhegeWeighted = Double.parseDouble(jianyanhege.get(i))  * remainingWeightPerFactor;
            double czjcWeighted = Double.parseDouble(czjc.get(i))  * remainingWeightPerFactor;
            double czjchegeWeighted = Double.parseDouble(czjchege.get(i))  * remainingWeightPerFactor;

            // 计算总指数
            double totalIndex = xukeWeighted + jianyanchaoqiWeighted + jianyanhegeWeighted + czjcWeighted + czjchegeWeighted;
            item.put("value",String.format("%.2f", totalIndex));
            data.add(item);
//            ydata.add(String.format("%.2f", totalIndex));
        }

        data = data.stream()
                .filter(map -> map.containsKey("value")) // 确保每个Map都包含指定的键
                .sorted(Comparator.comparingDouble(map -> {
                    // 检查并解析值，如果失败则返回Double.MIN_VALUE（或根据需要处理）
                    try {
                        return Double.parseDouble(map.get("value"));
                    } catch (NumberFormatException e) {
                        // 处理无法解析为double的情况，这里返回Double.MIN_VALUE表示最小
                        // 或者可以抛出自定义异常，记录日志等
                        return Double.MIN_VALUE;
                    }
                }))
                .collect(Collectors.toList());
        List<String> name = data.stream().map(map -> map.get("name")).collect(Collectors.toList());
        Collections.reverse(name);
        result.put("xdata", name);
        List<String> value = data.stream().map(map -> map.get("value")).collect(Collectors.toList());
        Collections.reverse(value);
        result.put("ydata", value);

        return result;
    }
}