package com.yeejoin.amos.boot.module.jg.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.jg.api.common.BizCustomDateSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author system_generator
 * @date 2023-12-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JgInstallationNoticeDto", description = "")
public class JgInstallationNoticeDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "告知单编号")
    private String applyNo;

    @ApiModelProperty(value = "设备监管码")
    private String supervisoryCode;

    @ApiModelProperty(value = "设备种类")
    private String equList;

    @ApiModelProperty(value = "告知状态编号")
    private String noticeStatus;

    @ApiModelProperty(value = "告知状态描述")
    private String noticeStatusDesc;

    @ApiModelProperty(value = "设备数量")
    private Integer deviceNum;

    @ApiModelProperty(value = "安装单位id")
    private String installUnitId;

    @ApiModelProperty(value = "安装许可证编号")
    private String installLicenseNo;

    @ApiModelProperty(value = "安装单位名称")
    private String installUnitName;

    @ApiModelProperty(value = "安装许可有效期")
    private Date installLicenseExpirationDate;

    @ApiModelProperty(value = "安装地点-区域代码")
    private String regionNo;

    @ApiModelProperty(value = "安装地点_省")
    private String province;

    @ApiModelProperty(value = "安装地点_市")
    private String city;

    @ApiModelProperty(value = "设备使用地点_区（县）")
    private String county;

    @ApiModelProperty(value = "安装地点_街道（镇）")
    private String street;

    @ApiModelProperty(value = "设备详细使用地址")
    private String address;

    @ApiModelProperty(value = "安装负责人ID")
    private String installLeaderId;

    @ApiModelProperty(value = "安装负责人")
    private String installLeaderName;

    @ApiModelProperty(value = "安装负责人手机")
    private String installLeaderPhone;

    @ApiModelProperty(value = "安装开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date installStartDate;

    @ApiModelProperty(value = "安装竣工日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date installEndDate;

    @ApiModelProperty(value = "产权单位id")
    private String propertyUnitId;

    @ApiModelProperty(value = "产权单位")
    private String propertyUnitName;

    @ApiModelProperty("产权单位统一信用代码")
    private String propertyUnitCreditCode;

    @ApiModelProperty(value = "使用单位id")
    private String useUnitCreditCode;

    @ApiModelProperty(value = "使用单位")
    private String useUnitName;

    @ApiModelProperty(value = "接收机构ID")
    private String receiveOrgCreditCode;

    @ApiModelProperty(value = "接收机构")
    private String receiveOrgName;

    @ApiModelProperty(value = "安装类型")
    private String installType;

    @ApiModelProperty(value = "委托单位")
    private String entrustingUnitName;

    @ApiModelProperty(value = "安装方案")
    private String installPlan;

    @ApiModelProperty(value = "流程建议")
    private String processAdvice;

    @ApiModelProperty(value = "作废原因")
    private String cancelReason;

    @ApiModelProperty(value = "撤销说明-未使用")
    private String cancelRemark;

    @ApiModelProperty(value = "撤销日期-未使用")
    private Date cancelHandleDeadline;

    @ApiModelProperty(value = "撤销流水号")
    private String cancelProcessNo;

    @ApiModelProperty(value = "施工合同是否本单位与甲方直接签署")
    private String isSignedWithA;

    @ApiModelProperty(value = "检验单位代码")
    private String inspectUnitId;

    @ApiModelProperty(value = "检验单位")
    private String inspectUnitName;

    @ApiModelProperty(value = "是否已报检")
    private String isInspected;

    @ApiModelProperty(value = "设备安装质量证明书编号")
    private String installCertNo;

    @ApiModelProperty(value = "审核通过时间")
    private Date receiveTime;

    @ApiModelProperty(value = "状态")
    private String status;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "创建人ID")
    private String createUserId;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    @ApiModelProperty(value = "录入单位ID")
    private String inputUnitNo;

    @ApiModelProperty(value = "安装委托书图片")
    private List<Map<String, Object>> proxyStatementAttachmentList;

    @ApiModelProperty(value = "安装合同照片")
    private List<Map<String, Object>> installContractAttachmentList;

    @ApiModelProperty(value = "安装委托书图片")
    private String proxyStatementAttachment;

    @ApiModelProperty(value = "安装合同照片")
    private String installContractAttachment;

    @ApiModelProperty(value = "是否西咸")
    private String isXixian;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    @ApiModelProperty(value = "告知日期")
    private Date noticeDate;

    @ApiModelProperty(value = "流程实例id")
    private String instanceId;

    @ApiModelProperty(value = "区名字")
    private String countyName;

    @ApiModelProperty(value = "市名字")
    private String cityName;

    @ApiModelProperty(value = "省名字")
    private String provinceName;

    @ApiModelProperty(value = "完整地址")
    private String fullAddress;

    @TableField(exist = false)
    @ApiModelProperty(value = "告知设备列表")
    private List<Map<String, Object>> deviceList;

    @ApiModelProperty(value = "告知单PDF URL")
    private String noticeReportUrl;

    public String getFullAddress() {
        return (StringUtils.isEmpty(this.provinceName) ? "" : this.provinceName)
                + (StringUtils.isEmpty(this.cityName) ? "" : this.cityName)
                + (StringUtils.isEmpty(this.countyName) ? "" : this.countyName)
                + (StringUtils.isEmpty(this.address) ? "" : this.address);
    }
   @ApiModelProperty(value = "设备注册代码")
   private String equRegisterCode;


    @ApiModelProperty(value = "设备使用地点-街道（镇）")
    private String factoryUseSiteStreet;


    @ApiModelProperty(value = "设备使用地点-街道（镇）")
    private String streetName;

    private List<String> roleIds;

    private  String dataType  ;

    private String nextExecuteIds;


    private String promoter;

    private String instanceStatus;

    @ApiModelProperty(value = "设备地址")
    private String equAddress;

    @ApiModelProperty(value = "办理日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date handleDate;

    private String createUserCompanyName;

    //下一步任务ID
    private String nextTaskId;

    /**
     * 创建人
     */
    private String createUserName;

    private String factoryNum;


    @ApiModelProperty (value = "下一节点可执行人")
    private String nextExecuteUserIds;


    private String transferToUserIds;

    /**
     * 属地监管部门code
     */
    private String orgBranchCode;

    /**
     * '属地监管部门name'
     */
    private String orgBranchName;

    @ApiModelProperty (value = "其他附件")
    private String otherAccessories;

    @ApiModelProperty (value = "其他附件")
    private List<Map<String, Object>> otherAccessoriesList;

    @ApiModelProperty(value = "告知书编号")
    private String informNumber;

    @ApiModelProperty(value = "96333码")
    private String code96333;

    @ApiModelProperty(value = "设备代码")
    private String equCode;

    @ApiModelProperty(value = "设备品种")
    private String equDefine;

    @ApiModelProperty(value = "设备类别")
    private String equipCategory;


    @ApiModelProperty(value = "作废人员id")
    private String cancelUserId;


    @ApiModelProperty(value = "作废日期")
    private Date cancelDate;


}
