package com.yeejoin.amos.boot.module.jg.biz.controller;


import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.jg.api.dto.FourColorCountDataDto;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.DPStatisticsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * 大屏统计controller
 *
 * @author Administrator
 */
@RestController
@RequestMapping("/db/statistics")
@Api(tags = "大屏统计")
public class DPStatisticsController {


    private DPStatisticsServiceImpl statisticsService;

    public DPStatisticsController(DPStatisticsServiceImpl statisticsService) {
        this.statisticsService = statisticsService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-右侧使用登记统计", notes = "大屏总览右侧-使用登记统计")
    @PostMapping(value = "/useRegister/count/byEquList")
    public ResponseModel<Map<String, Object>> useRegisterCountByEquList(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.useRegisterCountByEquList(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-中间地图左右两侧8大类、单位、人员数量全局统计", notes = "大屏总览中间-地图左右两侧8大类、单位、人员数量全局统计")
    @PostMapping(value = "/zl/center-map/legend")
    public ResponseModel<Map<String, Object>> centerMapCountForGlobal(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getCenterMapCountDataForGlobal(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-中间地图地市统计", notes = "大屏总览中间-地图地市统计")
    @PostMapping(value = "/zl/center-map/overview")
    public ResponseModel<List<Map<String, Object>>> centerMapCountForOverview(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getCenterMapCountDataForOverview(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏8大类-左侧气瓶使用登记统计", notes = "大屏八大类左侧-使用登记统计")
    @PostMapping(value = "/useRegisterCount")
    public ResponseModel<Map<String, Object>> useRegisterCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.useRegisterCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-左侧-安全指数", notes = "大屏总览-一码知风险-安全指数")
    @PostMapping(value = "/zl/left/safetyIndex")
    public ResponseModel<Map<String, Object>> querySafetyIndex(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.querySafetyIndex(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-左侧-四色管安全", notes = "大屏总览-左侧-四色管安全")
    @PostMapping(value = "/zl/left/fourColorManager")
    public ResponseModel<List<FourColorCountDataDto>> fourColorManagerSafety(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.queryFourColorManagerSafetyData(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-右侧-业务全过程", notes = "大屏总览-右侧-业务全过程")
    @PostMapping(value = "/zl/right/bizCycle")
    public ResponseModel<Map<String, Object>> queryBizCycleData(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.queryBizCycleData(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-左侧设备状态情况统计", notes = "监管大屏-左侧设备状态情况统计")
    @PostMapping(value = "/equStateCount")
    public ResponseModel<List<Map<String,Object>>> equStateCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.equStateCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-右侧停用、注销、报废设备状态情况统计", notes = "监管大屏-右侧停用、注销、报废设备状态情况统计")
    @PostMapping(value = "/equStopStateCount")
    public ResponseModel<Map<String,Object>> equStopStateCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.equStopStateCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-维保电梯数量TOP10", notes = "监管大屏-维保电梯数量TOP10")
    @PostMapping(value = "/maintenanceCountTopTen")
    public ResponseModel<List<Map<String,Object>>> maintenanceCountTopTen(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.maintenanceCountTopTen(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-维保电梯数量", notes = "监管大屏-维保电梯数量")
    @PostMapping(value = "/maintenanceCount")
    public ResponseModel<Map<String,Object>> maintenanceCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.maintenanceCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-左侧各地市业务办理平均时效", notes = "监管大屏-左侧各地市业务办理平均时效")
    @PostMapping(value = "/cityBusinessCount")
    public ResponseModel<Map<String,Object>> cityBusinessCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.cityBusinessCount(dpFilterParamDto));
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-左侧获取业务类型", notes = "监管大屏-左侧获取业务类型")
    @PostMapping(value = "/getBusinessKey")
    public ResponseModel<List<Map<String,Object>>> getBusinessKey(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getBusinessKey(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-右侧施工告知的设备数办理情况统计", notes = "监管大屏-右侧施工告知的设备数办理情况统计")
    @PostMapping(value = "/getNoticeEquCount")
    public ResponseModel<Map<String,Object>> getNoticeEquCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getNoticeEquCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-右侧使用办理的设备数量情况统计", notes = "监管大屏-右侧使用办理的设备数量情况统计")
    @PostMapping(value = "/getRegEquCount")
    public ResponseModel<Map<String,Object>> getRegEquCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getRegEquCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-左侧新增情况", notes = "监管大屏-左侧新增情况")
    @PostMapping(value = "/newRegEquCount")
    public ResponseModel<Map<String,Object>> newRegEquCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.newRegEquCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-新增登记新增设备统计", notes = "监管大屏-新增登记新增设备统计")
    @PostMapping(value = "/newRegCount")
    public ResponseModel<List<Map<String,Object>>> newRegCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.newRegCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏监管-中屏-各地市数据统计", notes = "大屏监管-中屏-各地市数据统计")
    @PostMapping(value = "/jg/centre/dataStatistic")
    public ResponseModel<List<Map<String, Object>>> dataStatisticByReginCode(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.dataStatisticByReginCode(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏监管-中屏-当前区域数据统计", notes = "大屏监管-中屏-当前区域数据统计")
    @PostMapping(value = "/jg/centre/dataStatisticCount")
    public ResponseModel<Map<String, Object>> dataStatisticCountByReginCode(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.dataStatisticCountByReginCode(dpFilterParamDto));
    }
}
