package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.yeejoin.amos.boot.module.jg.api.dto.CompanyEquipCountDto;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationMapper;
import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author Administrator
 */
@Component
@Slf4j
public class UseRegisterEquipUsedCheckImpl extends BaseEquipUsedCheckService {

    private RedissonClient redissonClient;

    private String bizType = "useRegister";

    private JgUseRegistrationMapper useRegistrationMapper;

    public UseRegisterEquipUsedCheckImpl(RedissonClient redissonClient, JgUseRegistrationMapper useRegistrationMapper) {
        this.redissonClient = redissonClient;
        this.useRegistrationMapper = useRegistrationMapper;
    }


    @Override
    public RedissonClient getRedisClient() {
        return redissonClient;
    }

    @Override
    public String getApplyBizType() {
        return bizType;
    }


    @Override
    public void init() {
        // 初始化已经完成或者在流程中使用登记的设备数据
        List<CompanyEquipCountDto> companyEquipCountDtos = useRegistrationMapper.queryForFlowingEquipList();
        companyEquipCountDtos.forEach(c -> {
            RBucket<Set<String>> rBucket = redissonClient.getBucket(this.getFlowingEquipRedisKey(c.getCompanyCode(), bizType));
            rBucket.set(Arrays.stream(c.getRecords().split(",")).collect(Collectors.toSet()));
        });
    }

}
