package com.yeejoin.amos.boot.module.jyjc.biz.controller;

import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.jyjc.api.dto.InspectionTimelinesDto;
import com.yeejoin.amos.boot.module.jyjc.api.dto.PublicityInspectOrgInfoDto;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.DPStatisticsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * 大屏统计controller
 *
 * @author Administrator
 */
@RestController
@RequestMapping("/db/statistics")
@Api(tags = "大屏统计")
public class DPStatisticsController {


    private DPStatisticsServiceImpl statisticsService;

    public DPStatisticsController(DPStatisticsServiceImpl statisticsService) {
        this.statisticsService = statisticsService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-右侧检验检测次数统计", notes = "按照维度设备种类、检验类型进行统计")
    @PostMapping(value = "/inspectTime/count/byEquListAndInspectType")
    public ResponseModel<Map<String, Object>> inspectTimeCountByTypeAndEquList(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.inspectTimeCountByTypeAndEquList(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏8大类-气瓶检验检测次数统计", notes = "气瓶检验检测次数统计")
    @PostMapping(value = "/inspectTimeCount")
    public ResponseModel<Map<String, Object>> inspectTimeCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.inspectTimeCount(dpFilterParamDto));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-左侧检验检测人员统计", notes = "大屏-检验检测-左侧检验检测人员统计")
    @PostMapping(value = "/jy/person/count")
    public ResponseModel<Map<String, Object>> inspectPersonCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.inspectPersonCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-各检验类型业务数量统计", notes = "大屏-检验检测-各检验类型业务数量统计")
    @PostMapping(value = "/jy/allApp/countByType")
    public ResponseModel<Map<String, Object>> inspectBizNumCountByType(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.queryAllFlowingAndFinishedInspectApp(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-各检验类型待检数量统计", notes = "大屏-检验检测-各检验类型待检数量统计")
    @PostMapping(value = "/jy/pendingApp/countByType")
    public ResponseModel<Map<String, Object>> queryAllFlowingAndFinishedInspectApp(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.queryAllPendingResultInspectApp(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-按机构进行检验时效统计Top10排名", notes = "大屏-检验检测-按机构进行检验时效统计Top10排名")
    @PostMapping(value = "/jy/timeliness/top")
    public ResponseModel<List<InspectionTimelinesDto>> inspectionTimelinessTopXX(@RequestParam(required = false, defaultValue = "10") String top, @Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.queryInspectionTimelinessTopXX(top, dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-检验检测机构公示", notes = "大屏-检验检测-检验检测机构公示")
    @PostMapping(value = "/jy/inspectionOrgList/publicity")
    public ResponseModel<List<PublicityInspectOrgInfoDto>> inspectionOrgListForPublicity(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.queryInspectionOrgListForPublicity(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-八大类设备报检/待检数量统计", notes = "大屏-检验检测-八大类设备报检/待检数量统计")
    @PostMapping(value = "/jy/inspectionEquip/countByEquList")
    public ResponseModel<Map<String, Object>> inspectionEquipCountByEquList(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.queryInspectionEquipByEquList(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-中间地图左侧全局统计", notes = "大屏-检验检测-中间地图左侧全局统计")
    @PostMapping(value = "/jy/center-map/legend")
    public ResponseModel<Map<String, Object>> centerMapCountForGlobal(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getCenterMapCountDataForGlobal(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-中间地图地市统计", notes = "大屏-检验检测-中间-地图地市统计")
    @PostMapping(value = "/jy/center-map/overview")
    public ResponseModel<List<Map<String, Object>>> centerMapCountForOverview(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getCenterMapCountDataForOverview(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-八大类设备检验临期、超期统计", notes = "大屏-检验检测-八大类设备检验临期、超期统计")
    @PostMapping(value = "/jy/equipInspectTime/countByEquList")
    public ResponseModel<Map<String, Object>> equipInspectTimeCountByEquList(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.equipInspectTimeCountByEquList(dpFilterParamDto));
    }

}
