package com.yeejoin.amos.boot.module.jyjc.biz.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

/**
 * @Author: xinglei
 * @Description:
 * @Date: 2020/8/24 9:58
 */
public class StringUtils {

    public static boolean contrastLowerStr(String str1, String str2) {
        boolean flag = false;
        if (str1.toLowerCase().equals(str2.toLowerCase())) {
            flag = true;
        }
        return flag;
    }

    /**
     * 将map转换成url
     *
     * @param map
     * @return
     */
    public static String transMap2UrlParam(Map<String, Object> map) {

        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            // 值为空或匹配total不拼接
            if (ValidationUtil.isEmpty(entry.getValue()) || "total".equals(entry.getKey()))
                continue;
            try {
                stringBuilder.append("&").append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue().toString(), "UTF-8"));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return stringBuilder.toString();
    }

    /**
     * 将list转换成url
     *
     * @param list
     * @return
     */
    public static String transList2UrlParam(List<Map<String, Object>> list) {
        StringBuilder stringBuilder = new StringBuilder();
        list.forEach(x -> {
            Map<String, Object> map = JSONObject.parseObject(JSON.toJSONString(x));
            try {
                stringBuilder.append("&").append(map.get("key")).append("=").append(URLEncoder.encode(map.get("value").toString(), "UTF-8"));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        });
        return stringBuilder.toString();
    }
}
