package com.yeejoin.amos.boot.module.tcm.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum PersonManageRoleEnum {
    /**
     * 人员管理角色枚举
     */
    code("人员管理角色字典code", 6616L),

    use("使用单位", 1735591519093547010L),
    agw("安装改造维修单位", 1735591458058035201L),
    jyjc("检验检测机构", 1735590873120399362L);

    String name;
    Long id;

    public static Map<Long, String> getName = new HashMap<>();
    public static Map<String, Long> getId = new HashMap<>();

    static {
        for (PersonManageRoleEnum e : PersonManageRoleEnum.values()) {
            getName.put(e.id, e.name);
            getId.put(e.name, e.id);
        }

    }
}
