package com.yeejoin.amos.boot.module.elevator.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 安全追溯-制造信息
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="produceInfo", description="制造信息")
public class ProduceInfoModel extends BaseDto {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "")
    private String supervisoryCode;

    private String instanceId;
    @ApiModelProperty(value = "")
    private String status;
    @ApiModelProperty(value = "制造单位统一社会信用代码")
    private String produceUnitCreditCode;
    @ApiModelProperty(value = "制造单位名")
    private String produceUnitName;
    @ApiModelProperty(value = "制造许可编号")
    private String produceLicenseNum;
    @ApiModelProperty(value = "出厂编号")
    private String factoryNum;
    @ApiModelProperty(value = "制造日期")
    private Date produceDate;
    @ApiModelProperty(value = "是否进口")
    private String imported;
    @ApiModelProperty(value = "制造国")
    private String produceCountry;
    @ApiModelProperty(value = "制造标准")
    private String factoryStandard;
    @ApiModelProperty(value = "制造附件")
    private String productQualityYieldProve;
    @ApiModelProperty(value = "安装及使用维护保养说明附件")
    private String insUseMaintainExplain;
    @ApiModelProperty(value = "监督检验证书附件")
    private String supervisionAgencyCredential;
    @ApiModelProperty(value = "型式试验证书附件")
    private String typeTestCredential;


}
