package com.yeejoin.amos.boot.module.cylinder.api.dto;

import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 微信公众号返回我的任务dto类
 * kongfm
 */
@Data
@ApiModel(value="WechatMyTaskDto", description="微信公众号返回我的任务dto类")
public class WechatMyTaskDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    protected Long sequenceNbr;

    @ApiModelProperty(value = "警情id")
    private Long alertId;

    @ApiModelProperty(value = "派遣单id")
    private Long paperId;

    @ApiModelProperty(value = "任务状态")
    private String taskStatus;

    @ApiModelProperty(value = "任务类别")
    private String taskType;

    @ApiModelProperty(value = "任务类别code")
    private String taskTypeCode;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "电梯识别码")
    private String rescueCode;

    @ApiModelProperty(value = "被困楼层")
    private String trappedFloorNum;

    @ApiModelProperty(value = "被困人数")
    private String trappedNum;

    @ApiModelProperty(value = "派遣时间")
    private Date dispatchTime;

    @ApiModelProperty(value = "有无人员伤亡")
    private String hasDeadHurt;

    @ApiModelProperty(value = "使用单位")
    private String useUnit;

    @ApiModelProperty(value = "使用单位id")
    private Long useUnitId;

    @ApiModelProperty(value = "使用单位主管机构")
    private String useUnitAuthority;

    @ApiModelProperty(value = "求援人电话")
    private String emergencyCall;

    @ApiModelProperty(value = "求援时间/ 报修时间/ 投诉时间")
    private Date recDate;

    @ApiModelProperty(value = "到达时间")
    private Date arriveTime;

    @ApiModelProperty(value = "救援完成时间")
    private Date saveTime;

    @ApiModelProperty(value = "救援单位")
    private String saveOrg;

    @ApiModelProperty(value = "任务接收人")
    private String taskResponseUser;

    @ApiModelProperty(value = "维修完成时间")
    private Date fixFinishTime;

    @ApiModelProperty(value = "维修单位")
    private String responseOrg;

    @ApiModelProperty(value = "维修人")
    private String responseUser;

    @ApiModelProperty(value = "故障原因")
    private String errorResult;

    @ApiModelProperty(value = "维修结果")
    private String fixResult;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "现场照片")
    private List<AttachmentDto> fixImgs;

    @ApiModelProperty(value = "故障描述")
    private String errorContent;

    @ApiModelProperty(value = "故障照片")
    private List<AttachmentDto> errorImgs;

    @ApiModelProperty(value = "反馈时间")
    private Date responseTime;

    @ApiModelProperty(value = "反馈人")
    private String feedbackUname;

    @ApiModelProperty(value = "结果评价")
    private String feedbackResult;

    @ApiModelProperty(value = "反馈备注")
    private String feedbackRemark;

    @ApiModelProperty(value = "反馈现场照片")
    private List<AttachmentDto> feedBackImgs;

    @ApiModelProperty(value = "处置时间")
    private Date dealTime;

    @ApiModelProperty(value = "处置单位")
    private String dealOrg;

    @ApiModelProperty(value = "处置人")
    private String dealUser;

    @ApiModelProperty(value = "处置结果")
    private String actionResult;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;
}
