package com.yeejoin.amos.api.householdapi.controller;

import com.yeejoin.amos.api.householdapi.Utils.HouseholdPvUtils;
import com.yeejoin.amos.api.householdapi.face.service.GoLangDataAcquisitionService;
import com.yeejoin.amos.api.householdapi.face.service.KSolarDataAcquisitionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.io.IOException;


/**
 * 户用光伏-厂商API haders
 *
 * @author system_generator
 * @date 2023-06-07
 */
@RestController
@Api(tags = "测试")
@RequestMapping(value = "/household-pv-api-test1")
public class HouseholdTestController {
    @Autowired
    private HouseholdPvUtils householdPvUtils;
    @Autowired
    private GoLangDataAcquisitionService goLangDataAcquisitionService;
    @Autowired
    private KSolarDataAcquisitionService kSolarDataAcquisitionService;


    /**
     * 新增户用光伏-厂商API haders
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/gdwdemo")
    @ApiOperation(httpMethod = "POST", value = "固德威示例", notes = "固德威示例")
    public String save(Long seq) throws IOException {
        return householdPvUtils.gerResponseByAPiID(seq);
    }

    /**
     * 新增户用光伏-厂商API haders
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/golangnew")
    @ApiOperation(httpMethod = "POST", value = "锦浪云", notes = "锦浪云")
    public void golangnew() throws IOException {
//        goLangDataAcquisitionService.stationList();
//          goLangDataAcquisitionService.stationDetail();
//        goLangDataAcquisitionService.collectorList();
////        goLangDataAcquisitionService.inverterList();
        goLangDataAcquisitionService.collectorDetail();
        goLangDataAcquisitionService.inverterDetail();
//        goLangDataAcquisitionService.inverAlramInfo();
    }

    /**
     * 新增户用光伏-厂商API haders
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/sofarnew")
    @ApiOperation(httpMethod = "POST", value = "首航", notes = "首航")
    public void sofarnew() throws IOException {
//        goLangDataAcquisitionService.stationList();
//          goLangDataAcquisitionService.stationDetail();
//        goLangDataAcquisitionService.collectorList();
////        goLangDataAcquisitionService.inverterList();
//        goLangDataAcquisitionService.collectorDetail();
//        goLangDataAcquisitionService.inverterDetail();
//        goLangDataAcquisitionService.inverAlramInfo();
    }

    /**
     * 新增户用光伏-厂商API haders
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/goodWenew")
    @ApiOperation(httpMethod = "POST", value = "固德威", notes = "固德威")
    public void goodWenew() throws IOException {
//        goLangDataAcquisitionService.stationList();
//          goLangDataAcquisitionService.stationDetail();
//        goLangDataAcquisitionService.collectorList();
////        goLangDataAcquisitionService.inverterList();
//        goLangDataAcquisitionService.collectorDetail();
//        goLangDataAcquisitionService.inverterDetail();
//        goLangDataAcquisitionService.inverAlramInfo();
    }

    /**
     * 新增户用光伏-厂商API haders
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/ksolarnew")
    @ApiOperation(httpMethod = "POST", value = "科士达", notes = "科士达")
    public void ksolarnew() throws IOException {
//        kSolarDataAcquisitionService.stationList();
        kSolarDataAcquisitionService.stationDetail();
        kSolarDataAcquisitionService.stationList();
        kSolarDataAcquisitionService.collectorList();
        kSolarDataAcquisitionService.collectorDetail();
////        goLangDataAcquisitionService.inverterList();
//        goLangDataAcquisitionService.collectorDetail();
//        goLangDataAcquisitionService.inverterDetail();
//        goLangDataAcquisitionService.inverAlramInfo();

    }
}
