package com.yeejoin.amos.api.householdapi.face.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.api.householdapi.Utils.GolangRequestUtil;
import com.yeejoin.amos.api.householdapi.constant.GoLangConstant;
import com.yeejoin.amos.api.householdapi.face.dto.AlarmDto;
import com.yeejoin.amos.api.householdapi.face.dto.CollectorDetailDto;
import com.yeejoin.amos.api.householdapi.face.dto.InverterDetailDto;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpCollector;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpInverter;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpInverterElectricity;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpStation;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.*;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpCollectorMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpInverterElectricityMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpInverterMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.*;
import com.yeejoin.amos.api.householdapi.face.service.GoLangDataAcquisitionService;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpStationMapper;
import com.yeejoin.amos.openapi.enums.PVProducerInfoEnum;
import fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Async
@Service
public class GoLangDataAcquisitionServiceImpl implements GoLangDataAcquisitionService {
    //定时任务执行频率 当前为10分钟一次
    private final String dataRequstScheduled = "0 0/60 * * * *";

    //锦浪云请求工具封装
    @Autowired
    private GolangRequestUtil golangRequestUtil;
    //锦浪云场站mapper
    @Autowired
    private GolangStationMapper golangStationMapper;
    //监盘场站mapper
    @Autowired
    private JpStationMapper jpStationMapper;
    //监盘采集器mapper
    @Autowired
    private JpCollectorMapper jpCollectorMapper;
    //监盘逆变器mapper
    @Autowired
    private JpInverterMapper jpInverterMapper;
    //监盘逆变器电量mapper
    @Autowired
    private JpInverterElectricityMapper jpInverterElectricityMapper;
    //锦浪云场站详情mapper
    @Autowired
    private GolangStationDetailMapper golangStationDetailMapper;
    //锦浪云采集器列表mapper
    @Autowired
    private GolangCollectorListMapper golangCollectorListMapper;
    //锦浪云逆变器列表
    @Autowired
    private GolangInverterListMapper golangInverterListMapper;
    //户用光伏场站历史mapper
    @Autowired
    private HYGFJPStationPowerHistoryMapper hygfjpStationPowerHistoryMapper;
    //户用光伏逆变器历史mapper
    @Autowired
    private HYGFJPInverterHistoryMapper hygfjpInverterHistoryMapper;
    //户用光伏采集器历史mapper
    @Autowired
    private HYGFJPCollectorHistoryMapper hygfjpCollectorHistoryMapper;
    //户用光伏逆变器告警
    @Autowired
    private HYGFJPInverterWarnMapper hygfjpInverterWarnMapper;
    //户用光伏逆变器历史mapper
    @Autowired
    private HYGFJPInverterElecHistoryMapper hygfjpInverterElecHistoryMapper;
    //户用光伏日发电量
    @Autowired
    private HYGFJPDayPowerMapper hygfjpDayPowerMapper;

    @Scheduled(cron = dataRequstScheduled)
    @Override
    public void stationList() {

        HashMap<String, Object> requestInfo = new HashMap<>();
        requestInfo.put("pageNo", 1);
        requestInfo.put("pageSize", 100);
        String requestParaminfo = JSON.toJSONString(requestInfo);
        List<GolangStationList> result = golangRequestUtil.getResPonse(GoLangConstant.stationListUrl,
                GoLangConstant.requestPost,
                requestParaminfo,
                GoLangConstant.resovleRule_data_page_records,
                GolangStationList.class
        );
        for (int i = 0; i < result.size(); i++) {
            GolangStationList golangStationList = result.get(i);
            golangStationList.setCreatedTime(System.currentTimeMillis());
            golangStationMapper.insert(golangStationList);
        }
    }

    @Scheduled(cron = dataRequstScheduled)
    @Override
    public void stationDetail() {
        List<String> stationIds = golangStationMapper.getStationIds();
        String today = DateUtil.today();
        String hour = new Date().getHours() + ":00";
        for (int i = 0; i < stationIds.size(); i++) {
            try {
                TimeUnit.SECONDS.sleep(1);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, Object> requestInfo = new HashMap<>();
            requestInfo.put("id", Long.valueOf(stationIds.get(i)));
            String requestParaminfo = JSON.toJSONString(requestInfo);
            List<GolangStationDetail> result = golangRequestUtil.getResPonse(GoLangConstant.stationDetailUrl,
                    GoLangConstant.requestPost,
                    requestParaminfo,
                    GoLangConstant.resovleRule_data,
                    GolangStationDetail.class
            );
            for (int j = 0; j < result.size(); j++) {
                GolangStationDetail golangStationDetail = result.get(j);
                golangStationDetail.setCreatedTime(System.currentTimeMillis());
                JpStation jpStation = jpStationMapper.selectOne(new QueryWrapper<JpStation>().
                        eq("third_code", PVProducerInfoEnum.JLY.getCode()).
                        eq("third_station_id", stationIds.get(i)));
                //给户用光伏存储的数据赋值
                if (ObjectUtils.isEmpty(jpStation)) {
                    jpStation = new JpStation();
                }
                jpStation.setSnCode(golangStationDetail.getNmicode());
                jpStation.setCapacity(Double.valueOf(golangStationDetail.getCapacity()));
                jpStation.setName(golangStationDetail.getStationname());
                jpStation.setPrice(Double.valueOf(golangStationDetail.getPrice()));
                jpStation.setAddress(golangStationDetail.getAddr());
                jpStation.setLongitude(golangStationDetail.getLongitude());
                jpStation.setLatitude(golangStationDetail.getLatitude());
                jpStation.setUserName(golangStationDetail.getUsername());
                jpStation.setUserPhone(String.valueOf(golangStationDetail.getUsermobile()));
                jpStation.setStationContact(String.valueOf(golangStationDetail.getMobile()).toLowerCase().replace("null", ""));
                jpStation.setModuleCount(ObjectUtils.isEmpty(Math.toIntExact(golangStationDetail.getModule()))?0:Math.toIntExact(golangStationDetail.getModule()));
                //并网类型
                jpStation.setState(GoLangConstant.stationStaus.get(String.valueOf(golangStationDetail.getState())));
                jpStation.setThirdStationId(String.valueOf(golangStationDetail.getId()));
                jpStation.setThirdCode(PVProducerInfoEnum.JLY.getCode());
                jpStation.setRealTimePower(golangStationDetail.getPower());
                jpStation.setOnGridType(GoLangConstant.intoNetWorkStatus.get(String.valueOf(golangStationDetail.getStationtypenew())));
                jpStation.setDayGenerate(golangStationDetail.getDayenergy());
                jpStation.setMonthGenerate(golangStationDetail.getMonthenergy() * GoLangConstant.mwhTokwh);
                jpStation.setYearGenerate(golangStationDetail.getYearenergy() * GoLangConstant.mwhTokwh);
                jpStation.setAccumulatedPower(golangStationDetail.getAllenergy() * GoLangConstant.mwhTokwh);
                jpStation.setDayIncome(golangStationDetail.getDayincome());
                jpStation.setMonthIncome(golangStationDetail.getMonthincome());
                jpStation.setYearIncome(golangStationDetail.getYearincome());
                jpStation.setCumulativeIncome(golangStationDetail.getAllincome());
                jpStation.setArea(golangStationDetail.getRegionstr());
                jpStation.setEmail(golangStationDetail.getUseremail());
                jpStation.setOnGridTime(new Date(golangStationDetail.getFispowertime()));
                jpStation.setAccessTime(new Date(golangStationDetail.getFisgeneratetime()));
                jpStation.setCreateTime(new Date(golangStationDetail.getCreatedate()));
                jpStation.setRatedPower(Double.valueOf(golangStationDetail.getInverterpower()));
                if (!ObjectUtils.isEmpty(jpStation.getSequenceNbr())) {
                    jpStationMapper.updateById(jpStation);
                } else {
                    jpStationMapper.insert(jpStation);
                }
                HYGFJPStationPowerHistory hygfjpStationPowerHistory = new HYGFJPStationPowerHistory();
                hygfjpStationPowerHistory.setCreatedTime(System.currentTimeMillis());
                hygfjpStationPowerHistory.setThirdStationId(jpStation.getThirdStationId());
                hygfjpStationPowerHistory.setPower(golangStationDetail.getPower());
                hygfjpStationPowerHistory.setThirdCode(jpStation.getThirdCode());
                hygfjpStationPowerHistory.setTime(System.currentTimeMillis());
                hygfjpStationPowerHistoryMapper.insert(hygfjpStationPowerHistory);
                HYGFJPDayPower hygfjpDayPower = hygfjpDayPowerMapper.selectOne(
                        new QueryWrapper<HYGFJPDayPower>().
                                eq("tation_id", stationIds.get(i)).
                                eq("year_month_day", today).
                                eq("hour", hour)
                );
                if (ObjectUtils.isEmpty(hygfjpDayPower)) {
                    hygfjpDayPower = new HYGFJPDayPower();
                }
                hygfjpDayPower.setTationId(stationIds.get(i));
                hygfjpDayPower.setHour(hour);
                hygfjpDayPower.setYearMonthDay(today);
                hygfjpDayPower.setPower(golangStationDetail.getPower());
                if (ObjectUtils.isEmpty(hygfjpDayPower.getCreatedTime())) {
                    hygfjpDayPower.setCreatedTime(System.currentTimeMillis());
                    hygfjpDayPowerMapper.insert(hygfjpDayPower);
                } else {
                    hygfjpDayPowerMapper.insert(hygfjpDayPower);
                }
            }
        }
    }


    @Scheduled(cron = dataRequstScheduled)
    @Override
    public void collectorList() {
        List<String> stationIds = golangStationMapper.getStationIds();
        for (int i = 0; i < stationIds.size(); i++) {
            try {
                TimeUnit.SECONDS.sleep(1);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, Object> requestInfo = new HashMap<>();
            requestInfo.put("stationId", Long.valueOf(stationIds.get(i)));
            requestInfo.put("pageNo", 1);
            requestInfo.put("pageSize", 100);
            String requestParaminfo = JSON.toJSONString(requestInfo);
            List<GolangCollectorList> result = golangRequestUtil.getResPonse(GoLangConstant.collectorListUrl,
                    GoLangConstant.requestPost,
                    requestParaminfo,
                    GoLangConstant.resovleRule_data_page_records,
                    GolangCollectorList.class
            );
            for (int j = 0; j < result.size(); j++) {
                GolangCollectorList golangCollectorList = result.get(j);
                golangCollectorList.setCreatedTime(System.currentTimeMillis());
                golangCollectorListMapper.insert(golangCollectorList);
            }
        }
    }

    @Scheduled(cron = dataRequstScheduled)
    @Override
    public void collectorDetail() {
        List<Long> collectorIds = golangCollectorListMapper.getCollectIds();
        for (int i = 0; i < collectorIds.size(); i++) {
            try {
                TimeUnit.SECONDS.sleep(1);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, Object> requestInfo = new HashMap<>();
            requestInfo.put("id", Long.valueOf(collectorIds.get(i)));
            String requestParaminfo = JSON.toJSONString(requestInfo);
            List<CollectorDetailDto> result = golangRequestUtil.getResPonse(GoLangConstant.collectorDetailUrl,
                    GoLangConstant.requestPost,
                    requestParaminfo,
                    GoLangConstant.resovleRule_data,
                    CollectorDetailDto.class
            );
            for (int j = 0; j < result.size(); j++) {
                CollectorDetailDto collectorDetailDto = result.get(j);
                JpCollector jpCollector = jpCollectorMapper.selectOne(new QueryWrapper<JpCollector>().
                        eq("third_station_id", collectorDetailDto.getStationId()).
                        eq("third_code", PVProducerInfoEnum.JLY.getCode()).
                        eq("sn_code", collectorDetailDto.getSn()));
                if (ObjectUtils.isEmpty(jpCollector)) {
                    jpCollector = new JpCollector();
                }
                //sn编码
                jpCollector.setSnCode(collectorDetailDto.getSn());
                //类型
                jpCollector.setType(collectorDetailDto.getModel());
                //更新时间
                jpCollector.setUpdateTime(new Date());
                //出场日期
                jpCollector.setDischargeDate(new Date(collectorDetailDto.getFactoryTime()));
                //生产日期
                jpCollector.setProductDate(new Date(collectorDetailDto.getFactoryTime()));
                //数据上传间隔
                jpCollector.setDataPeriod(collectorDetailDto.getDataUploadCycle());
                //本次上电时间
                jpCollector.setThisWorkTime(new DateTime(collectorDetailDto.getCurrentWorkingTime()));
                //累计工作时间
                jpCollector.setTotalWorkTime(new DateTime(collectorDetailDto.getTotalWorkingTime()));
                //第三方电站id
                jpCollector.setThirdStationId(collectorDetailDto.getStationId());
                //第三方厂商标识
                jpCollector.setThirdCode(PVProducerInfoEnum.JLY.getCode());
                //第三方厂商标识
                jpCollector.setState(GoLangConstant.stationStaus.get(collectorDetailDto.getState()));

                jpCollector.setStationName(collectorDetailDto.getStationName());
                jpCollector.setAddr(collectorDetailDto.getAddr());
                jpCollector.setName(collectorDetailDto.getName());
                if (ObjectUtils.isEmpty(jpCollector.getSequenceNbr())) {
                    jpCollectorMapper.insert(jpCollector);
                } else {
                    jpCollectorMapper.updateById(jpCollector);
                }
                // td-collector-history
                HYGFJPCollectorHistory hygfjpCollectorHistory = new HYGFJPCollectorHistory();
                hygfjpCollectorHistory.setTime(System.currentTimeMillis());
                hygfjpCollectorHistory.setCreatedTime(System.currentTimeMillis());
                hygfjpCollectorHistory.setSnCode(collectorDetailDto.getSn());
                hygfjpCollectorHistory.setSignalStrength(Double.valueOf(collectorDetailDto.getRssiLevel()));
                hygfjpCollectorHistory.setThirdStationId(collectorDetailDto.getStationId());
                hygfjpCollectorHistory.setThirdCode(PVProducerInfoEnum.JLY.getCode());
                hygfjpCollectorHistoryMapper.insert(hygfjpCollectorHistory);
            }
        }
    }

    @Scheduled(cron = dataRequstScheduled)
    @Override
    public void inverterList() {
        List<String> stationIds = golangStationMapper.getStationIds();
        for (int i = 0; i < stationIds.size(); i++) {
            try {
                TimeUnit.SECONDS.sleep(1);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, Object> requestInfo = new HashMap<>();
            requestInfo.put("stationId", Long.valueOf(stationIds.get(i)));
            requestInfo.put("pageNo", 1);
            requestInfo.put("pageSize", 100);
            String requestParaminfo = JSON.toJSONString(requestInfo);
            List<GolangInverterList> result = golangRequestUtil.getResPonse(GoLangConstant.inverterListUrl,
                    GoLangConstant.requestPost,
                    requestParaminfo,
                    GoLangConstant.resovleRule_data,
                    GolangInverterList.class
            );
            for (int j = 0; j < result.size(); j++) {
                GolangInverterList golangInverterList = result.get(j);
                golangInverterList.setCreatedTime(System.currentTimeMillis());
                golangInverterListMapper.insert(golangInverterList);
            }
        }
    }

    @Scheduled(cron = dataRequstScheduled)
    @Override
    public void inverterDetail() {
        List<String> inverterSns = golangInverterListMapper.getInverterSns();
        for (int i = 0; i < inverterSns.size(); i++) {
            try {
                TimeUnit.SECONDS.sleep(1);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, Object> requestInfo = new HashMap<>();
            requestInfo.put("sn", inverterSns.get(i));
            String requestParaminfo = JSON.toJSONString(requestInfo);
            List<InverterDetailDto> result = golangRequestUtil.getResPonse(GoLangConstant.inverterDetailUrl,
                    GoLangConstant.requestPost,
                    requestParaminfo,
                    GoLangConstant.resovleRule_data,
                    InverterDetailDto.class
            );
            for (int j = 0; j < result.size(); j++) {
                InverterDetailDto inverterDetailDto = result.get(j);
                JpInverter jpInverter = jpInverterMapper.selectOne(new QueryWrapper<JpInverter>().
                        eq("third_station_id", inverterDetailDto.getStationId()).
                        eq("third_code", PVProducerInfoEnum.JLY.getCode()).
                        eq("sn_code", inverterDetailDto.getSn()));
                if (ObjectUtils.isEmpty(jpInverter)) {
                    jpInverter = new JpInverter();
                }
                jpInverter.setSnCode(inverterDetailDto.getSn());
                jpInverter.setState(GoLangConstant.stationStaus.get(inverterDetailDto.getCurrentState()));
                jpInverter.setCollectorId(String.valueOf(inverterDetailDto.getCollectorId()));
                jpInverter.setCollectorSnCode(inverterDetailDto.getCollectorsn());
                jpInverter.setUpdateTime(new Date());
                jpInverter.setCurrentPower(inverterDetailDto.getPac());
                jpInverter.setDayPowerGeneration(inverterDetailDto.getEToday());
                jpInverter.setMonthPowerGeneration(inverterDetailDto.getEMonth() * GoLangConstant.mwhTokwh);
                jpInverter.setYearPowerGeneration(inverterDetailDto.getEYear() * GoLangConstant.mwhTokwh);
                jpInverter.setTotalPowerGeneration(inverterDetailDto.getETotal() * GoLangConstant.mwhTokwh);
                jpInverter.setBrand(inverterDetailDto.getName());
                jpInverter.setModel(inverterDetailDto.getProductModel());
                jpInverter.setNationalStandard(inverterDetailDto.getNationalStandards());
                jpInverter.setVersion(inverterDetailDto.getVersion());
                jpInverter.setGenerationHours(String.valueOf(inverterDetailDto.getFullHour()));
                jpInverter.setId(inverterDetailDto.getId());
                jpInverter.setCapacity(inverterDetailDto.getPower().intValue());
                jpInverter.setThirdStationId(String.valueOf(inverterDetailDto.getStationId()));
                jpInverter.setThirdCode(PVProducerInfoEnum.JLY.getCode());
                jpInverter.setStationName(inverterDetailDto.getStationName());
                if (!ObjectUtils.isEmpty(jpInverter.getSequenceNbr())) {
                    jpInverterMapper.updateById(jpInverter);
                } else {
                    jpInverterMapper.insert(jpInverter);
                }
                String jsonString = JSON.toJSONString(inverterDetailDto);
                Map<String, Object> hanlderResult = JSON.parseObject(jsonString, Map.class);
                for (int k = 1; k < 4; k++) {
                    JpInverterElectricity jpInverterElectricity = jpInverterElectricityMapper.selectOne(new QueryWrapper<JpInverterElectricity>().
                            eq("sn_code", inverterDetailDto.getSn()).
                            eq("type", "交流").
                            eq("name", "AC" + k)
                    );
                    if (ObjectUtils.isEmpty(jpInverterElectricity)) {
                        jpInverterElectricity = new JpInverterElectricity();
                    }
                    jpInverterElectricity.setInverterId(String.valueOf(inverterDetailDto.getId()));
                    jpInverterElectricity.setSnCode(inverterDetailDto.getSn());
                    jpInverterElectricity.setThirdCode(PVProducerInfoEnum.JLY.getCode());
                    jpInverterElectricity.setThirdStationId(String.valueOf(inverterDetailDto.getStationId()));
                    jpInverterElectricity.setType("交流");
                    jpInverterElectricity.setName("AC" + k);
                    jpInverterElectricity.setVoltage(Double.valueOf(hanlderResult.get("uAc" + k).toString()));
                    jpInverterElectricity.setCurrent(Double.valueOf(hanlderResult.get("iAc" + k).toString()));
                    if (ObjectUtils.isEmpty(jpInverterElectricity.getSequenceNbr())) {
                        jpInverterElectricityMapper.insert(jpInverterElectricity);
                    } else {
                        jpInverterElectricityMapper.updateById(jpInverterElectricity);
                    }
                }
                for (int k1 = 1; k1 < 33; k1++) {
                    JpInverterElectricity jpInverterElectricity = jpInverterElectricityMapper.selectOne(new QueryWrapper<JpInverterElectricity>().
                            eq("sn_code", inverterDetailDto.getSn()).
                            eq("type", "直流").
                            eq("name", "PV" + k1)
                    );
                    if (ObjectUtils.isEmpty(jpInverterElectricity)) {
                        jpInverterElectricity = new JpInverterElectricity();
                    }
                    jpInverterElectricity.setInverterId(String.valueOf(inverterDetailDto.getId()));
                    jpInverterElectricity.setSnCode(inverterDetailDto.getSn());
                    jpInverterElectricity.setThirdCode(PVProducerInfoEnum.JLY.getCode());
                    jpInverterElectricity.setThirdStationId(String.valueOf(inverterDetailDto.getStationId()));
                    jpInverterElectricity.setType("直流");
                    jpInverterElectricity.setName("PV" + k1);
                    jpInverterElectricity.setVoltage(Double.valueOf(hanlderResult.get("uPv" + k1).toString()));
                    jpInverterElectricity.setCurrent(Double.valueOf(hanlderResult.get("iPv" + k1).toString()));
                    jpInverterElectricity.setPower(Double.valueOf(hanlderResult.get("pow" + k1).toString()));
                    if (ObjectUtils.isEmpty(jpInverterElectricity.getSequenceNbr())) {
                        jpInverterElectricityMapper.insert(jpInverterElectricity);
                    } else {
                        jpInverterElectricityMapper.updateById(jpInverterElectricity);
                    }
                }
                HYGFJPInverterElecHistory hygfjpInverterElecHistory = new HYGFJPInverterElecHistory();
                hygfjpInverterElecHistory.setThirdStationId(String.valueOf(inverterDetailDto.getStationId()));
                hygfjpInverterElecHistory.setCreatedTime(System.currentTimeMillis());
                hygfjpInverterElecHistory.setSnCode(inverterDetailDto.getSn());
                hygfjpInverterElecHistory.setUAcCurrent(inverterDetailDto.getIAc1());
                hygfjpInverterElecHistory.setVAcCurrent(inverterDetailDto.getIAc2());
                hygfjpInverterElecHistory.setWAcCurrent(inverterDetailDto.getIAc3());
                hygfjpInverterElecHistory.setUAcVoltage(inverterDetailDto.getUAc1());
                hygfjpInverterElecHistory.setVAcVoltage(inverterDetailDto.getUAc2());
                hygfjpInverterElecHistory.setWAcVoltage(inverterDetailDto.getUAc3());
                hygfjpInverterElecHistory.setThirdCode(PVProducerInfoEnum.JLY.getCode());
                hygfjpInverterElecHistory.setTime(System.currentTimeMillis());
                hygfjpInverterElecHistoryMapper.insert(hygfjpInverterElecHistory);
                // 逆变器历史
                String today = DateUtil.today();
                HYGFJPInverterHistory hygfjpInverterHistory = hygfjpInverterHistoryMapper.selectOne(new QueryWrapper<HYGFJPInverterHistory>().eq("sn_code", inverterDetailDto.getSn()).eq("date", today));
                if (ObjectUtils.isEmpty(hygfjpInverterHistory)) {
                    hygfjpInverterHistory = new HYGFJPInverterHistory();
                }
                hygfjpInverterHistory.setDate(today);
                hygfjpInverterHistory.setThirdStationId(String.valueOf(inverterDetailDto.getStationId()));
                hygfjpInverterHistory.setInverterId(String.valueOf(inverterDetailDto.getId()));
                hygfjpInverterHistory.setSnCode(inverterDetailDto.getSn());
                hygfjpInverterHistory.setThirdCode(PVProducerInfoEnum.JLY.getCode());
                hygfjpInverterHistory.setGenerationHours(inverterDetailDto.getFullHour());
                hygfjpInverterHistory.setPowerGeneration(inverterDetailDto.getEToday());
                if (ObjectUtils.isEmpty(hygfjpInverterHistory.getCreatedTime())) {
                    hygfjpInverterHistory.setCreatedTime(System.currentTimeMillis());
                    hygfjpInverterHistoryMapper.insert(hygfjpInverterHistory);
                } else {
                    hygfjpInverterHistoryMapper.insert(hygfjpInverterHistory);
                }
            }
        }
    }

    @Scheduled(cron = dataRequstScheduled)
    @Override
    public void inverAlramInfo() {
        List<String> inverterIds = golangInverterListMapper.getInverterSns();
        for (int i = 0; i < inverterIds.size(); i++) {
            try {
                TimeUnit.SECONDS.sleep(1);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, Object> requestInfo = new HashMap<>();
            requestInfo.put("pageNo", 1);
            requestInfo.put("pageSize", 100);
            requestInfo.put("alarmDeviceSn", inverterIds.get(i));
            requestInfo.put("alarmBeginTime", DateUtil.today());
            requestInfo.put("alarmEndTime", DateUtil.today());
            String requestParaminfo = JSON.toJSONString(requestInfo);
            List<AlarmDto> result = golangRequestUtil.getResPonse(GoLangConstant.alarmListUrl,
                    GoLangConstant.requestPost,
                    requestParaminfo,
                    GoLangConstant.resovleRule_data_records,
                    AlarmDto.class
            );
            for (int j = 0; j < result.size(); j++) {
                AlarmDto alarmDto = result.get(j);
                if (!ObjectUtils.isEmpty(alarmDto.getAlarmDeviceSn())) {
                    HYGFJPInverterWarn hygfjpInverterWarn = hygfjpInverterWarnMapper.selectOne(new QueryWrapper<HYGFJPInverterWarn>()
                            .eq("sn_code", alarmDto.getAlarmDeviceSn())
                            .eq("start_time", alarmDto.getAlarmBeginTime())
                            .eq("third_station_id", String.valueOf(alarmDto.getStationId()))
                    );
                    if (ObjectUtils.isEmpty(hygfjpInverterWarn)) {
                        hygfjpInverterWarn = new HYGFJPInverterWarn();
                    }
                    hygfjpInverterWarn.setTime(System.currentTimeMillis());
                    hygfjpInverterWarn.setTimeLong(System.currentTimeMillis());
                    hygfjpInverterWarn.setSnCode(alarmDto.getAlarmDeviceSn());
                    hygfjpInverterWarn.setThirdStationId(String.valueOf(alarmDto.getStationId()));
                    hygfjpInverterWarn.setLevel(GoLangConstant.alarmLevel.get(alarmDto.getAlarmLevel()));
                    hygfjpInverterWarn.setContent(alarmDto.getAlarmMsg());
                    hygfjpInverterWarn.setThirdCode(PVProducerInfoEnum.JLY.getCode());
                    hygfjpInverterWarn.setTreatment(alarmDto.getAdvice());
                    hygfjpInverterWarn.setStartTime(alarmDto.getAlarmBeginTime());
                    hygfjpInverterWarn.setRecoverTime(alarmDto.getAlarmEndTime());
                    hygfjpInverterWarn.setState(GoLangConstant.alarmstatus.get(alarmDto.getState()));
                    if (ObjectUtils.isEmpty(hygfjpInverterWarn.getCreatedTime())) {
                        hygfjpInverterWarn.setCreatedTime(System.currentTimeMillis());
                        hygfjpInverterWarnMapper.insert(hygfjpInverterWarn);
                    } else {
                        hygfjpInverterWarnMapper.insert(hygfjpInverterWarn);
                    }
                }
            }
        }
    }

}
