package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 勘察明细
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_survey_details",autoResultMap = true)
public class SurveyDetails extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 勘察表id
     */
    @TableField("survey_information_id")
    private Long surveyInformationId;

    /**
     * 勘察时间
     */
	@TableField("surveyor_time")
    private Date surveyorTime;

    /**
     * 房屋类型
     */
	@TableField(value = "house_type",typeHandler = FastjsonTypeHandler.class)
    private List<String> houseType;

    /**
     * 房屋整体情况
     */
	@TableField("house_situation")
    private String houseSituation;

    /**
     * 勘察人
     */
	@TableField("surveyor")
    private String surveyor;

    /**
     * 房屋整体情况备注
     */
	@TableField("house_situation_notes")
    private String houseSituationNotes;

    /**
     * 房屋层数
     */
	@TableField("house_layers")
    private Integer houseLayers;

    /**
     * 房屋总高
     */
	@TableField("house_height")
    private Integer houseHeight;

    /**
     * 房屋偏向
     */
	@TableField("house_bias")
    private String houseBias;


    /**
     * 手机指南正截图
     */
    @TableField(value = "compass",typeHandler = FastjsonTypeHandler.class)
    private List<Object> compass;
    /**
     * 房屋偏向备注
     */
	@TableField("house_bias_notes")
    private String houseBiasNotes;

    /**
     * 房屋年限
     */
	@TableField("house_life")
    private Integer houseLife;

    /**
     * 地理位置-经度
     */
	@TableField("location_long")
    private String locationLong;

    /**
     * 地理位置-维度
     */
	@TableField("location_lat")
    private String locationLat;

    /**
     * 地理位置-海拔
     */
	@TableField("location_alt")
    private String locationAlt;

    /**
     * 屋顶通道
     */
	@TableField(value = "roofway",typeHandler = FastjsonTypeHandler.class)
    private List<String> roofway;

    /**
     * 屋顶通道备注
     */
	@TableField("roofway_notes")
    private String roofwayNotes;

    /**
     * 周边障碍物
     */
	@TableField(value = "obstacle",typeHandler = FastjsonTypeHandler.class)
    private List<String> obstacle;

    /**
     * 周边障碍物备注
     */
	@TableField("obstacle_notes")
    private String obstacleNotes;

    /**
     * 遮挡物
     */
	@TableField(value = "screen",typeHandler = FastjsonTypeHandler.class)
    private List<String> screen;

    /**
     * 遮挡物备注
     */
	@TableField("screen_notes")
    private String screenNotes;

    /**
     * 解决措施
     */
	@TableField(value = "solution_measures",typeHandler = FastjsonTypeHandler.class)
    private  List<String> solutionMeasures;

    /**
     * 房屋产权
     */
	@TableField("house_property")
    private String houseProperty;

    /**
     * 承重是否符合要求
     */
	@TableField("house_bearing")
    private String houseBearing;

    /**
     * 是否有明显裂痕
     */
	@TableField("house_crack")
    private String houseCrack;

    /**
     * 屋顶可铺设面积
     */
	@TableField("roof_area")
    private String roofArea;

    /**
     * 电表位置
     */
	@TableField("meter_position")
    private String meterPosition;

    /**
     * 原电表位置
     */
	@TableField("original_meter_position")
    private String originalMeterPosition;

    /**
     * 原电表位置备注
     */
	@TableField("original_meter_position_notes")
    private String originalMeterPositionNotes;

    /**
     * 原电表参数
     */
	@TableField("original_meter_position_parameter")
    private String originalMeterPositionParameter;

    /**
     * 进户线
     */
	@TableField("incoming_line")
    private String incomingLine;

    /**
     * 进户线备注
     */
	@TableField("incoming_line_notes")
    private String incomingLineNotes;

    /**
     * 逆变器位置预估
     */
	@TableField("inverter_position")
    private String inverterPosition;

    /**
     * 逆变器位置预估备注
     */
	@TableField("inverter_position_notes")
    private String inverterPositionNotes;

    /**
     * 电表箱位置预估
     */
	@TableField("meter_box")
    private String meterBox;

    /**
     * 电表箱位置预估备注
     */
	@TableField("meter_box_notes")
    private String meterBoxNotes;

    /**
     * 支架接地预估
     */
	@TableField("support")
    private String support;

    /**
     * 支架接地预估备注
     */
	@TableField("support_notes")
    private String supportNotes;

    /**
     * 电表箱接地预估
     */
	@TableField("grounding")
    private String grounding;

    /**
     * 电表箱接地预估备注
     */
	@TableField("grounding_notes")
    private String groundingNotes;

    /**
     * 关于邻居采光遮挡
     */
	@TableField("daylighting_obstruction")
    private String daylightingObstruction;

    /**
     * 房屋整体文件标识
     */
	@TableField(value = "overall_housing_survey",typeHandler = FastjsonTypeHandler.class)
    private List<Object> overallHousingSurvey;

    /**
     * 房屋周边文件标识
     */
	@TableField(value = "surrounding_house_survey",typeHandler = FastjsonTypeHandler.class)
    private List<Object> surroundingHouseSurvey;

    /**
     * 房屋内部整体照片文件标识
     */
	@TableField(value = "inside_house_survey",typeHandler = FastjsonTypeHandler.class)
    private List<Object> insideHouseSurvey;

    /**
     * 电表参数文件标识
     */
	@TableField(value = "electricity_survey",typeHandler = FastjsonTypeHandler.class)
    private List<Object> electricitySurvey;

    /**
     * 屋顶全貌文件标识
     */
	@TableField(value = "panorama_survey",typeHandler = FastjsonTypeHandler.class)
    private List<Object> panoramaSurvey;

    /**
     * 屋顶平面草图文件标识
     */
	@TableField(value = "plan_sketch_survey",typeHandler = FastjsonTypeHandler.class)
    private List<Object> planSketchSurvey;

    /**
     * 房屋方位角文件标识
     */
	@TableField(value = "azimuth_survey",typeHandler = FastjsonTypeHandler.class)
    private List<Object> azimuthSurvey;

    /**
     * 其他附件文件标识
     */
	@TableField(value = "other_accessory_survey",typeHandler = FastjsonTypeHandler.class)
    private List<Object> otherAccessorySurvey;

}
