package com.yeejoin.amos.boot.module.jxiop.biz.mapper2;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.FullViewRecallDataDTO;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanHealthIndex;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanHealthLevel;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 *  Mapper 接口
 *
 * @author system_generator
 * @date 2023-08-15
 */
public interface IdxBizFanHealthIndexMapper extends BaseMapper<IdxBizFanHealthIndex> {

    BigDecimal getHealthScoreInfo(@Param("areaCode") String areaCode, @Param("stationCode") String stationCode);

    List<Map<String, Object>> getHealthListInfo(@Param("areaCode") String areaCode, @Param("stationCode") String stationCode);

    List<Map<String, Object>> getAllEquipAlarmInfo(@Param("tableName") String tableName);

    List<Map<String, Object>> getHealthInfoByArea();

    List<Map<String, Object>> getAllEquipAlarmInfoByStation();


    List<Map<String, Object>> getHealthInfoByStation(@Param("areaCode") String areaCode);

    List<Map<String, Object>> equipWarningRadarMap(@Param("stationCode") String stationCode);

    List<Map<String, Object>> getAllEquipAlarmInfoAnalysisByStationType(@Param("tableName") String tableName,
                                                                        @Param("areaCode") String areaCode,
                                                                        @Param("tableName2") String tableName2);

    List<Map<String, Object>> getAllEquipAlarmInfoAnalysisByArea(@Param("areaCode") String areaCode);

    List<Map<String, Object>> getSubSystemInfo(@Param("equipmentName") String equipmentName, @Param("gatewayId") String gatewayId);

    List<Map<String, Object>> getFanInfoByPage(@Param("gatewayId") String gatewayId);

    List<Map<String, Object>> getFanHealthInfoList(@Param("gatewayId") String gatewayId);

    List<Map<String, Object>> getSumSystemListByEquipment(@Param("gatewayId") String gatewayId, @Param("equipmentName") String equipmentName);

    List<Map<String, Object>> getPointNameListBySumSystem(@Param("gatewayId") String gatewayId, @Param("subSystem") String subSystem);


    List<Map<String, Object>> getHealthInfoBySubSystem(@Param("subSystem") String subSystem, @Param("gatewayId") String gatewayId);





    List<Map<String, Object>> getPvInfoByPage(@Param("gatewayId") String gatewayId);

    List<Map<String, Object>> getPvHealthInfoList(@Param("gatewayId") String gatewayId);



    List<Map<String, Object>> getPvSubSystemInfo(@Param("subarray") String subarray, @Param("gatewayId") String gatewayId);

    List<Map<String, Object>> getPvSumSystemListByEquipment(@Param("gatewayId") String gatewayId, @Param("subarray") String subarray);





    List<Map<String, Object>> getPvHealthInfoBySubSystem(@Param("equipmentName") String equipmentName, @Param("gatewayId") String gatewayId);

    List<Map<String, Object>> getPvPointNameListBySumSystem(@Param("gatewayId") String gatewayId, @Param("equipmentName") String equipmentName);



    String getPointNameByIndexAddress(@Param("varDesc") String varDesc,
                                      @Param("tableName") String tableName);

    List<FullViewRecallDataDTO> getFullViewRecall();

    List<Map<String, Object>> getStationIndexInfo();

    List<Map<String, Object>> getEquipmentIndexInfo();

    List<Map<String, Object>> getSubSystemIndexInfo();

    List<Map<String, Object>> getPointNameIndexInfo();


    List<IdxBizFanHealthLevel> getHealthLevelInfoList();


    List<String> getAddressInfo();
}
