package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ColModel;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.DataGridMock;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.EquipAlarmEventDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ResultsData;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.EquipAlarmEvent;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.EquipAlarmEventMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

@Service
public class EquipAlarmEventServiceImpl extends BaseService<EquipAlarmEventDto, EquipAlarmEvent, EquipAlarmEventMapper> {

    @Autowired
    EquipAlarmEventMapper equipAlarmEventMapper;
    @Autowired
    StationBasicMapper stationBasicMapper;

    public ResultsData getEventByEquipIndex(String gatewayId, int current, int size, String equipIndex, String frontModule) {
        List<EquipAlarmEventDto> equipAlarmEvents = new ArrayList<>();
        LambdaQueryWrapper<EquipAlarmEvent> queryWrapper = new LambdaQueryWrapper<>();
        if(equipIndex!=null) 
        {
            queryWrapper.eq(EquipAlarmEvent::getEquipIndex, equipIndex);
        }
        queryWrapper.eq(EquipAlarmEvent::getGatewayId, gatewayId);
        if(frontModule!=null) 
        {
            queryWrapper.eq(EquipAlarmEvent::getFrontModule, frontModule);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DAY_OF_MONTH, -7);
        queryWrapper.gt(EquipAlarmEvent::getCreatedTime, calendar.getTime());
        int count = equipAlarmEventMapper.selectCount(queryWrapper);
        
        IPage<EquipAlarmEvent> p = new Page<>(current, size);
        equipAlarmEvents=  equipAlarmEventMapper.getAlarmEventList(gatewayId, equipIndex, frontModule, (p.getCurrent()-1)*p.getSize(), p.getSize(),calendar.getTime());
        //  equipAlarmEvents = equipAlarmEventMapper.selectList(queryWrapper);
        //  equipAlarmEvents=page.getRecords();
        equipAlarmEvents.forEach(i->{
        	if("true".equals(i.getValue())) 
        	{
        		i.setValue("合");
        	}else 
        	{
        		i.setValue("分");
        	}
        });
        DataGridMock DataGridMock = new DataGridMock(current, count, false, current, equipAlarmEvents);
        ColModel colModelEventMovement = new ColModel("equipName", "equipName", "设备名", "设备名", "dataGrid", "equipName");
        ColModel colModelStationName = new ColModel("alarmDesc", "alarmDesc", "事件描述", "事件描述", "dataGrid", "alarmDesc");
        ColModel colModelEventDesc = new ColModel("createdTime", "createdTime", "告警时间", "告警时间", "dataGrid", "createdTime");
        ColModel colModelValueDesc = new ColModel("value", "value", "动作", "动作", "dataGrid", "value");
        List<ColModel> listColModel = Arrays.asList(colModelEventMovement, colModelStationName, colModelEventDesc,colModelValueDesc);
        ResultsData resultsData = new ResultsData(DataGridMock, listColModel);
        return resultsData;
    }
}
