package com.yeejoin.amos.patrol.business.util;

import com.yeejoin.amos.patrol.business.param.PlanTaskPageParam;
import com.yeejoin.amos.patrol.core.common.request.CommonPageable;
import com.yeejoin.amos.patrol.core.common.request.CommonRequest;
import com.yeejoin.amos.patrol.core.enums.QueryOperatorEnum;
import org.springframework.util.ObjectUtils;

import java.util.HashMap;
import java.util.List;

public class PlanTaskPageParamUtil {

    public static PlanTaskPageParam fillChkInfoParam(List<CommonRequest> queryRequests, CommonPageable commonPageable,
                                                     PlanTaskPageParam param, HashMap<String, Object> paramMap) {
        for (int i = 0; i < queryRequests.size(); i++) {
            String name = queryRequests.get(i).getName();
            if ("pointNo".equals(name)) {
                param.setPointNo(toString(queryRequests.get(i).getValue()));
            } else if ("pointName".equals(name)) {
                param.setPointName(toString(queryRequests.get(i).getValue()));
            } else if ("beginDate".equals(name)) {
                param.setBeginDate(toString(queryRequests.get(i).getValue()));
            } else if ("endDate".equals(name)) {
                param.setEndDate(toString(queryRequests.get(i).getValue()));
            } else if ("status".equals(name)) {
                param.setStatus(toString(queryRequests.get(i).getValue()));
            } else if ("planId".equals(name)) {
                param.setPlanId(toString(queryRequests.get(i).getValue()));
            } else if ("routeId".equals(name)) {
                param.setRouteId(toString(queryRequests.get(i).getValue()));
            }
        }
        param.setOrgCode(paramMap.get("orgCode") == null ? null : paramMap.get("orgCode").toString());
        param.setUserId(paramMap.get("userId") == null ? null : paramMap.get("userId").toString());
        if (!ObjectUtils.isEmpty(commonPageable)) {
            param.setPageNumber(commonPageable.getPageNumber());
            param.setPageSize(commonPageable.getPageSize());
        }

        return param;
    }

    private static String toString(Object value) {
        if (null == value || value == "") {
            return null;
        } else {
            return value.toString();
        }
    }

    public static void fillPlanTask(List<CommonRequest> queryRequests,
                                    HashMap<String, Object> params) {
        if (ObjectUtils.isEmpty(queryRequests)) {
            return;
        }
        StringBuilder order = new StringBuilder();
        for (CommonRequest queryRequest : queryRequests) {
            String name = queryRequest.getName();
            String type = queryRequest.getType();
            if (type != null && !"".equals(type)) {
                if (!QueryOperatorEnum.ORDER_BY.getName().equals(type)) {
                    params.put(name, queryRequest.getValue());
                } else {
                    order.append(name).append(" ").append(queryRequest.getValue());
                }
            } else {
                if ("orderBy".equals(name) && queryRequest.getValue() != null) {
                    order.append(queryRequest.getValue());
                }
                params.put(name, queryRequest.getValue());
            }
        }
        if (!ObjectUtils.isEmpty(order.toString())) {
            params.put("orderBy", order.toString());
        } else {
            params.put("orderBy", "beginTime ASC");
        }
    }

}
