package com.yeejoin.amos.boot.module.ymt.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum EquipmentClassifityEnum {

    /**
     * *设备分类
     */
    GL("锅炉", "1000"),
    YLRQ("压力容器", "2000"),
    DT("电梯", "3000"),
    QZJX("起重机械", "4000"),
    CC("场（厂）内专用机动车辆", "5000"),
    YLSS("大型游乐设施", "6000"),
    YLGDYJ("压力管道元件", "7000"),
    YLGD("压力管道", "8000"),
    KYSD("客运索道", "9000"),
    //树类型

    ZHTJFX("综合统计分析","statistical"),

    //设备认领状态
    SBRLZT("设备认领状态", "rlzt"),
    BDLS("八大类树", "eightCategory"),
    RENLING("其他", "other");
    private String name;
    private String code;
    public static Map<String, String> getName = new HashMap<>();
    public static Map<String, String> getCode = new HashMap<>();

    static {
        for (EquipmentClassifityEnum e : EquipmentClassifityEnum.values()) {
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
        }

    }


    public static String getNameByCode(String code) {
        for (EquipmentClassifityEnum value : EquipmentClassifityEnum.values()) {
            if (value.getCode().equals(code)) {
                return value.getName();
            }
        }
        return "";
    }

    public static EquipmentClassifityEnum getOne(String code) {
        for (EquipmentClassifityEnum value : EquipmentClassifityEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
}
