package com.yeejoin.amos.boot.biz.common.utils;

import org.typroject.tyboot.core.foundation.context.RequestContext;

public class RequestContextWrapper {
    private final String appKey;
    private final String product;
    private final String token;
    private final String exeUserId;

    private RequestContextWrapper(String appKey, String product, String token, String exeUserId) {
        this.appKey = appKey;
        this.product = product;
        this.token = token;
        this.exeUserId = exeUserId;
    }

    /**
     * 捕获当前线程上下文
     * @return RequestContextWrapper
     */
    public static RequestContextWrapper capture() {
        return new RequestContextWrapper(
            RequestContext.getAppKey(),
            RequestContext.getProduct(),
            RequestContext.getToken(),
            RequestContext.getExeUserId()
        );
    }

    /**
     * 应用上下文到目标线程
     */
    public void apply() {
        RequestContext.setAppKey(appKey);
        RequestContext.setProduct(product);
        RequestContext.setToken(token);
        RequestContext.setExeUserId(exeUserId);
    }
}