package com.yeejoin.amos.boot.module.cylinder.flc.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.cylinder.flc.biz.service.impl.UnitInfoChangeServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.UnitInfoChangeDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 企业信息变更表
 *
 * @author system_generator
 * @date 2021-11-11
 */
@RestController
@Api(tags = "企业信息变更表Api")
@RequestMapping(value = "/flc-unit-info-change")
public class UnitInfoChangeController extends BaseController {

    @Autowired
	UnitInfoChangeServiceImpl unitInfoChangeServiceImpl;

    /**
     * 新增企业信息变更表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增企业信息变更表", notes = "新增企业信息变更表")
	public ResponseModel<UnitInfoChangeDto> save(@RequestBody UnitInfoChangeDto model) {
	    model = unitInfoChangeServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新企业信息变更表", notes = "根据sequenceNbr更新企业信息变更表")
	public ResponseModel<UnitInfoChangeDto> updateBySequenceNbrFlcUnitInfoChange(@RequestBody UnitInfoChangeDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(unitInfoChangeServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除企业信息变更表", notes = "根据sequenceNbr删除企业信息变更表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(unitInfoChangeServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个企业信息变更表",  notes = "根据sequenceNbr查询单个企业信息变更表")
	public ResponseModel<UnitInfoChangeDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(unitInfoChangeServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "企业信息变更表分页查询",  notes = "企业信息变更表分页查询")
	public ResponseModel<Page<UnitInfoChangeDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
                    (value = "size") int size) {
	    Page<UnitInfoChangeDto> page = new Page<UnitInfoChangeDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(unitInfoChangeServiceImpl.queryForFlcUnitInfoChangePage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "企业信息变更表列表全部数据查询",   notes = "企业信息变更表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<UnitInfoChangeDto>> selectForList() {
	    return ResponseHelper.buildResponse(unitInfoChangeServiceImpl.queryForFlcUnitInfoChangeList());
	}
}
