package com.yeejoin.amos.boot.module.jg.api.dto;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

import java.util.HashMap;
import java.util.Map;

public class InspectConclusionConverter implements Converter<String> {

    public static final Map<String, String> dictMap = new HashMap<>();

    static {
        // 填充映射关系
        dictMap.put("合格", "6040");
        dictMap.put("不合格", "6041");
        dictMap.put("复检合格", "6042");
        dictMap.put("复检不合格", "6043");
        dictMap.put("整改后合格", "6045");
        dictMap.put("符合", "6046");
        dictMap.put("不符合", "6047");
        dictMap.put("符合要求", "6048");
        dictMap.put("基本符合要求", "6049");
        dictMap.put("不符合要求", "6050");
        dictMap.put("允许使用", "6051");
        dictMap.put("降压使用", "6052");
        dictMap.put("进行合于使用评价", "6053");
        dictMap.put("其他", "6044");
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        // 实体类中对象属性类型
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty,
                                    GlobalConfiguration globalConfiguration) {
        // 从Cell中读取数据
        String cellValue = cellData.getStringValue();
        // 判断Excel中的值，将其转换为预期的数值
        return dictMap.getOrDefault(cellValue, null);
    }

    @Override
    public CellData convertToExcelData(String o, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return new CellData("");
    }
}