package com.yeejoin.amos.boot.module.ymt.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
/**
 * ${comments}
 *
 * @author cpp
 * @date 2023-04-21 11:08:35
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="mainParts", description="主要零部件技术参数")
public class MainPartsModel extends BaseDto {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty(value = "")
    private String instanceId;
    @ApiModelProperty(value = "")
    private String status;
    @ApiModelProperty(value = "零部件号")
    private String mainPartNumber;
    @ApiModelProperty(value = "型号规格")
    private String typeSpecification;
    @ApiModelProperty(value = "制造单位")
    private String manufactureCompany;
    @ApiModelProperty(value = "产品编号")
    private String identificatioProduct;
    @ApiModelProperty(value = "制造日期")
    private Date manufacturingDate;
    @ApiModelProperty(value = "名称")
    private String designation;
    @ApiModelProperty(value = "备注")
    private String remarks;
    @ApiModelProperty(value = "型号(厂车技术)	")
    private String model;
    @ApiModelProperty(value = "规格(厂车技术)	")
    private String specification;
    @ApiModelProperty(value = "型式试验证书编号")
    private String certificateNumber;
    @ApiModelProperty(value = "序号")
    private String serialNumber;
    @ApiModelProperty(value = "气瓶批号	")
    private String batchNumber;
    @ApiModelProperty(value = "单位内编号")
    private String intraUnitNumber;
    @ApiModelProperty(value = "净重	")
    private BigDecimal weight;
    @ApiModelProperty(value = "管道名称")
    private String pipeName;
    @ApiModelProperty(value = "管道编号	")
    private String pipelineNumber;
    @ApiModelProperty(value = "设备级别")
    private String deviceLevel;
    @ApiModelProperty(value = "设计标准")
    private String designCriterion;
    @ApiModelProperty(value = "管道图号	")
    private String figureNumber;
    @ApiModelProperty(value = "零部件名称")
    private String partName;

}
