package com.yeejoin.amos.boot.module.jcs.api.service;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.common.api.dto.RequestData;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertCalledTodyDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertCalledZhDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.KeyValueLabel;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerData;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;

import java.util.List;
import java.util.Map;

/**
* 警情接警记录 服务类
*
* @author tb
* @date 2021-06-17
*/
public interface IAlertCalledService {
	 /*
	  * 根据id 修改警情
	  * type：警情相关 操作类型  警情续报   非警情确认    警情结案
	  * */
	 boolean updateAlertCalled(Long id, String code);

	 /**
	  *
	  * 指挥系统 未结束的警情列表
	  *
	  * **/

     List<AlertCalledZhDto> alertCalledListByAlertStatus(Integer pageNum, Integer pageSize,RequestData par);

	  int  alertCalledListByAlertStatusCount(RequestData par);

     /**
	  *
	  * 根据灾情id 查询灾情详情
	  *
	  * **/
	   Object selectAlertCalledById( Long id);

	   Object selectAlertCalledByIdNoRedis(Long id);

	   Object selectAlertCalledByIdNoRedisNew(Long id);



	   Map<String,Object>   selectAlertCalledKeyValueLabelById( Long id);
	   
	   List<KeyValueLabel>   selectAlertCalledcount( Long id);

	   List<KeyValueLabel>   powercount( Long id);

	   List<PowerData> getPowerDataList(Long id);
	   AlertCalled getAlertCalledById(Long id);


	   Integer AlertCalledcountTime(int type);

	List<AlertCalledTodyDto> getTodayAlertCalled();

	/**
	 * app-根据警情id获取处置对象
	 *
	 * @param alertId
	 * @return
	 */
	List<JSONObject> queryDisposalObjectList(String alertId);

	/**
	 * app-根据警情id查询警情详情
	 *
	 * @param id
	 * @return
	 */
	Map<String, Object> queryAlertCalledById(Long id);


	Integer AlertCalledcount(int type);


	List<AlertCalled> AlertCalledStatusPage(Integer current, Integer size);
}
