package com.yeejoin.amos.boot.module.ugp.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 安装告知表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="InstallNoticeDto", description="安装告知表")
public class InstallNoticeDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "项目id")
    private Long projectId;

    @ApiModelProperty(value = "告知申请提交日期")
    private Date noticeDate;

    @ApiModelProperty(value = "告知申请状态")
    private String noticeStatus;

    @ApiModelProperty(value = "组织机构代码")
    private String organizationCode;

    @ApiModelProperty(value = "许可单位名称")
    private String licenseCompany;

    @ApiModelProperty(value = "许可证编号")
    private String licenseNum;

    @ApiModelProperty(value = "许可单位id")
    private Long licenseCompanyId;

    @ApiModelProperty(value = "合同文件")
    private String contractAttch;

    @ApiModelProperty(value = "许可证文件")
    private String licenseAttch;

    @ApiModelProperty(value = "是否审批通过（1通过，0未通过）")
    private Boolean approved;

    @ApiModelProperty(value = "备注")
    private String remark;

}
