package com.yeejoin.amos.boot.module.ugp.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 质量问题表
 *
 * @author system_generator
 * @date 2022-09-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="QualityProblemDto", description="质量问题表")
public class QualityProblemDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "项目id")
    private Long projectId;

    @ApiModelProperty(value = "质量问题编号")
    private String code;

    @ApiModelProperty(value = "问题产生阶段")
    private String generateStage;

    @ApiModelProperty(value = "问题描述")
    private String desc;

    @ApiModelProperty(value = "问题等级")
    private String level;

    @ApiModelProperty(value = "产生问题的阶段对应检验信息id")
    private Long stageVerifyId;

    @ApiModelProperty(value = "处理进度")
    private String processProgress;

    @ApiModelProperty(value = "整改书提交状态（1已提交/0未提交）")
    private Boolean submitStatus;

    @ApiModelProperty(value = "问题提交日期")
    private Date submitDate;

    @ApiModelProperty(value = "问题分类（1继续整改/2转问题处理单）")
    private Boolean problemType;

    @ApiModelProperty(value = "审查项目是否存在问题（1是/0否）")
    private Boolean reviewStatus;

    @ApiModelProperty(value = "处理方案（附件上传）")
    private String solution;

    @ApiModelProperty(value = "处理方案说明")
    private String solutionDesc;

    @ApiModelProperty(value = "处理意见（附件上传）")
    private String handingOpinion;

    @ApiModelProperty(value = "处理意见说明")
    private String handingOpinionDesc;

    @ApiModelProperty(value = "整改书（附件上传）")
    private String reformDoc;

    @ApiModelProperty(value = "整改书说明")
    private String reformDesc;

    @ApiModelProperty(value = "整改期限")
    private Date reformLimitDate;

    @ApiModelProperty(value = "是否限期内整改（1是/0否）")
    private Boolean rectifyWithinTime;

}
