package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.ugp.api.Enum.WeldCodeEnum;
import com.yeejoin.amos.boot.module.ugp.api.Enum.WeldMethodEnum;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.entity.Weld;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProjectMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.WeldMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IWeldService;
import com.yeejoin.amos.boot.module.ugp.api.dto.WeldDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.foundation.utils.DateUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 焊口信息表服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public
class WeldServiceImpl extends BaseService<WeldDto, Weld, WeldMapper> implements IWeldService {

    @Autowired
    WeldMapper weldMapper;
    @Autowired
    ProjectMapper projectMapper;


    Logger logger = LoggerFactory.getLogger(WeldServiceImpl.class);


    /**
     * 分页查询
     */
    public Page<WeldDto> queryForWeldPage(int current, int size) {

        Page<WeldDto> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        Page<WeldDto> weldDtoPage = this.queryForPage(page, null, false);

        for (WeldDto weldDto : weldDtoPage.getRecords()) {
            QueryWrapper<Project> wrapper = new QueryWrapper<>();
            wrapper.eq("code", weldDto.getProjectId());
            Project project = projectMapper.selectOne(wrapper);
            weldDto.setName(project.getName());

            QueryWrapper<Project> wrapperUnit = new QueryWrapper<>();
            wrapperUnit.eq("installation_unit_id", weldDto.getInstallCompany());
            List<Project> projects = projectMapper.selectList(wrapperUnit);
            for (Project project1 : projects) {
                weldDto.setInstallationUnit(project1.getInstallationUnit());
                weldDto.setCodingStatus(WeldCodeEnum.map.get(weldDto.getCodingStatus()));
                weldDto.setCodingMethod(WeldMethodEnum.map.get(weldDto.getCodingMethod()));
            }
        }
        return weldDtoPage;

    }

    /**
     * 列表查询 示例
     */
    public List<WeldDto> queryForWeldList() {
        return this.queryForList("", false);
    }

    /**
     * 生成焊口编号保存并查询
     */
    // 静态变量存储最大值
    private static final AtomicInteger atomicNum = new AtomicInteger();
    // 初始化编号
    private final int INIT_CODE_NUM = 0;

    public synchronized void getCode(Long sequenceNbr, int number) throws Exception {

        List<Weld> welds = new ArrayList<>();
        Project project = projectMapper.selectById(sequenceNbr);
        QueryWrapper<Weld> wrapper = new QueryWrapper<>();

        wrapper.eq("project_id", project.getCode()).orderByDesc("code").last("limit 1");
        Weld weld1 = weldMapper.selectOne(wrapper);

        if (weld1 != null) {
            String substring = weld1.getCode().substring(13, 17);
            atomicNum.set(Integer.parseInt(substring));
            for (int i = 0; i < number; i++) {
                Weld weld = new Weld();
                String i1 = String.format("%04d", atomicNum.incrementAndGet());
                String code = "XM" + (project.getCode()) + "-HK" + i1;
                weld.setRegion(project.getAddress());
                weld.setProjectId(Long.valueOf(project.getCode()));
                weld.setInstallCompany(project.getInstallationUnitId());
                weld.setCode(code);
                weld.setRegion(project.getAddress());
                weld.setCodingMethod("0");
                weld.setCodingStatus("1");
                weld.setCodingDate(new Date());
                welds.add(weld);
            }
            saveBatch(welds);
        } else {
            atomicNum.set(0);
            for (int i = 0; i < number; i++) {
                Weld weld = new Weld();
                String i1 = String.format("%04d", atomicNum.incrementAndGet());
                String code = "XM" + (project.getCode()) + "-HK" + i1;
                weld.setRegion(project.getAddress());
                weld.setProjectId(Long.valueOf(project.getCode()));
                weld.setInstallCompany(project.getInstallationUnitId());
                weld.setCode(code);
                weld.setRegion(project.getAddress());
                weld.setCodingMethod("0");
                weld.setCodingStatus("1");
                weld.setCodingDate(new Date());
                welds.add(weld);
            }
            saveBatch(welds);
        }


    }
}