package com.yeejoin.amos.latentdanger.business.param;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;

import javax.persistence.Column;
import java.util.Date;
import java.util.List;

/**
 * @author tb
 * @title: LatentDangerDto
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2021/1/26 14:48
 */
@Data
public class LatentDangerDto {

    /**
     * 隐患等级（1：一般隐患；2：重大隐患；0：安全问题）
     */
    private String dangerLevel;

    /**
     * 隐患等级名称
     */
    private String dangerLevelName;

    /**
     * 问题描述
     */
    private String remark;

    /**
     * 创建隐患的业务id（p_check_input）
     */
    private Long bizId = 0L;

    /**
     * 建筑id
     */
    private Long structureId;

    /**
     * 建筑名称
     */
    private String structureName;

    private String instanceKey;

    /**
     * 隐患名称
     */
    private String dangerName;

    /**
     * 整改日期
     */
    private Date reformLimitDate;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 纬度
     */
    private String latitude;

    /**
     * 隐患图片列表
     */
    private List<String> photoUrl;

    /**
     * 检查项名称
     */
    private String inputItemName;

    /**
     * 风险点id
     */
    private String riskSourceId;

    /**
     * 隐患地址
     */
    private String dangerPosition;

    /**
     * 治理方式
     */
    private String reformType;

    /**
     * 治理方式名称
     */
    private String reformTypeName;

    /**
     * 是否删除（0未删除、1已删除）
     */
    private Boolean deleted = false;

    /**
     * 主键
     */
    private Long id;

    /**
     * 隐患状态
     */
    private String dangerState;

    /**
     * 隐患状态名称
     */
    private String dangerStateName;

    /**
     * 业务类型（不同业务创建的隐患以此区分:巡检隐患、防火监督隐患、其他隐患。。。）
     */
    private String bizType;

    /**
     * 检查类型（1无码检查、2计划检查、3无计划检查、4随手拍）
     */
    private String checkMode;

    /**
     * 业务信息
     */
    private JSONObject bizInfo;
}
