package com.yeejoin.equipmanage.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.equipmanage.common.enums.EquipStatusEnum;
import com.yeejoin.equipmanage.remote.RemoteSecurityService;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.Car;
import com.yeejoin.equipmanage.common.entity.EquipmentDetail;
import com.yeejoin.equipmanage.common.entity.Journal;
import com.yeejoin.equipmanage.common.entity.Maintain;
import com.yeejoin.equipmanage.common.entity.MaintainDetail;
import com.yeejoin.equipmanage.common.entity.StockDetail;
import com.yeejoin.equipmanage.common.enums.BillContentEnum;
import com.yeejoin.equipmanage.common.enums.JournalTypeEnum;
import com.yeejoin.equipmanage.common.enums.NoticeEnum;
import com.yeejoin.equipmanage.mapper.MaintainMapper;
import com.yeejoin.equipmanage.service.ICarService;
import com.yeejoin.equipmanage.service.IEquipmentDetailService;
import com.yeejoin.equipmanage.service.IJournalService;
import com.yeejoin.equipmanage.service.IMaintainDetailService;
import com.yeejoin.equipmanage.service.IMaintainService;
import com.yeejoin.equipmanage.service.INoticeService;
import com.yeejoin.equipmanage.service.IStockBillService;
import com.yeejoin.equipmanage.service.IStockDetailService;

/**
 * 服务实现类
 *
 * @author wujiang
 * @date 2020-07-14
 */
@Service
public class MaintainServiceImpl extends ServiceImpl<MaintainMapper, Maintain> implements IMaintainService {

	@Autowired
	private IMaintainService maintainService;

	@Autowired
	private IMaintainDetailService maintainDetailService;

	@Autowired
	private IStockDetailService stockDetailService;

	@Autowired
	private IEquipmentDetailService equipmentDetailService;

	@Autowired
	private IJournalService journalService;

	@Autowired
	private INoticeService noticeService;

	@Autowired
	private IStockBillService stockBillService;

	@Autowired
	private ICarService carService;

	@Override
	public Maintain exec(List<MaintainDetail> list, String type, AgencyUserModel agencyUserModel) throws Exception {
		if (BillContentEnum.ZB.getCode().equals(type)) {
			for (int i = 0; i < list.size(); i++) {
				StockDetail stockDetail = stockDetailService.getById(list.get(i).getStockDetailId());
				if (stockDetail == null) {
					throw new Exception("查询库存失败，请联系管理员");
				}
				if (EquipStatusEnum.ONCAR.getCode().toString().equals(stockDetail.getStatus())) {
//					if(i == list.size()-1){
//						CZbuffer.append(stockDetail.getEquipmentDetail().getName());
//					}else{
//						CZbuffer.append(stockDetail.getEquipmentDetail().getName()).append(",");
//					}
					throw new Exception("请先在手机端卸载装备再进行维修或保养");
				}
			}
		}
		Maintain maintain = new Maintain();
		maintain.setBillCode(stockBillService.generateQrCode("BY"));
		maintain.setBillType(type);
		maintain.setMaintainTime(new Date());
		maintain.setCreatorName(agencyUserModel.getRealName());
		maintainService.save(maintain);
		if (BillContentEnum.ZB.getCode().equals(type)) {
			// wl_stock_detail表
			saveEquipMaintainDetail(list, maintain.getId());
			// wl_journal表
			saveEquipJournal(list, agencyUserModel);
			// 仓库id
			// Long warehouseId =
			// stockDetailService.getById(list.get(0).getStockDetailId()).getWarehouseId();
		} else {
			// wl_stock_detail表
			saveCarMaintainDetail(list, maintain.getId());
			// wl_journal表
			saveCarJournal(list, agencyUserModel);

		}
		// wl_notice表
		noticeService.saveNotice(NoticeEnum.MAINTIAN, maintain.getId(), maintain.getBillCode(),
				BillContentEnum.getEnum(type));
		return maintain;
	}

	private void saveEquipMaintainDetail(List<MaintainDetail> list, Long maintainId) {
		List<MaintainDetail> maintainDetaillist = new ArrayList<>();
		for (MaintainDetail maintainDetail : list) {
			maintainDetail.setContent("装备保养");
			maintainDetail.setAmount(maintainDetail.getAmount());
			maintainDetail.setMaintainId(maintainId);
			StockDetail stockDetail = stockDetailService.getById(maintainDetail.getStockDetailId());
			if(stockDetail==null){
				throw new RuntimeException("请先入库后，在保养");
			}
			EquipmentDetail equipmentDetail = equipmentDetailService.getById(stockDetail.getEquipmentDetailId());
			if (equipmentDetail.getMaintenanceCycle() != null
					&& equipmentDetail.getMaintenanceCycle().intValue() != 0) {
				maintainDetail.setCycle(equipmentDetail.getMaintenanceCycle().intValue());
				maintainDetail
						.setNextTime(DateUtils.addMonths(new Date(), equipmentDetail.getMaintenanceCycle().intValue()));
			}
			maintainDetaillist.add(maintainDetail);
		}
		maintainDetailService.saveBatch(maintainDetaillist);
	}

	private void saveEquipJournal(List<MaintainDetail> list, AgencyUserModel agencyUserModel) {
		List<Journal> journalList = new ArrayList<Journal>();
		for (MaintainDetail maintainDetail : list) {
			Journal journal = new Journal();
			StockDetail stockDetail = stockDetailService.getById(maintainDetail.getStockDetailId());
			journal.setAmount(stockDetail.getAmount());
			journal.setEquipmentDetailId(stockDetail.getEquipmentDetailId());
			journal.setStockDetailId(stockDetail.getId());
			journal.setRemark(agencyUserModel.getRealName() + " 进行了" + JournalTypeEnum.BY.getName());
			journal.setWarehouseStructureId(stockDetail.getWarehouseStructureId());
			journal.setState(JournalTypeEnum.BY.getCode());
			journalList.add(journal);
		}
		journalService.saveBatch(journalList);
	}

	private void saveCarMaintainDetail(List<MaintainDetail> list, Long maintainId) {
		List<MaintainDetail> maintainDetaillist = new ArrayList<>();
		for (MaintainDetail maintainDetail : list) {
			maintainDetail.setContent("车辆保养");
			maintainDetail.setMaintainId(maintainId);
			maintainDetail.setAmount(1.0);
			Car car = carService.getById(maintainDetail.getCarId());
			if (car.getMaintenanceCycle() != null && car.getMaintenanceCycle().intValue() != 0) {
				maintainDetail.setCycle(car.getMaintenanceCycle().intValue());
				maintainDetail.setNextTime(DateUtils.addMonths(new Date(), car.getMaintenanceCycle().intValue()));
			}
			maintainDetaillist.add(maintainDetail);
		}
		maintainDetailService.saveBatch(maintainDetaillist);
	}

	private void saveCarJournal(List<MaintainDetail> list, AgencyUserModel agencyUserModel) {
		List<Journal> journalList = new ArrayList<Journal>();
		for (MaintainDetail maintainDetail : list) {
			Journal journal = new Journal();
			Car car = carService.getById(maintainDetail.getCarId());
			journal.setAmount(1.0);
			journal.setCarId(car.getId());
			journal.setStockDetailId(car.getId());
			journal.setRemark(agencyUserModel.getRealName() + " 进行了车辆" + JournalTypeEnum.BY.getName());
			journal.setState(JournalTypeEnum.BY.getCode());
			journal.setCarId(car.getId());
			journalList.add(journal);
		}
		journalService.saveBatch(journalList);
	}
}
