package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarm;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarmLog;
import com.yeejoin.equipmanage.common.entity.vo.AlamVideoVO;

import java.util.List;
import java.util.Map;

/**
 * @author zjw
 * 确警接口
 */
public interface IConfirmAlarmService extends IService<EquipmentSpecificAlarm> {

    /**
     * 根据id查询确警页面相关数据
     */
    Map<String ,Object> getDetailsById( Long alamId,  Long equipId , String type, String area);

    Map<String ,Integer> videoList(List<String> list);

    void confirmAlam(EquipmentSpecificAlarmLog ent, String appKey, String product, String token, String userId);

    /**
     * 未处理消防告警
     */
    Integer getFireAlarm();

    /**
     * 未处理物联告警
     */
    Integer getFaultAlarm();

    Map<String, Object> getEquipSceneAndRelationVideo(Long equipmentSpecificId);
}
