package com.yeejoin.amos.boot.biz.common.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface ResultFieldMapping {
    /**
     * 需要转换的字段配置
     */
    ResultFieldMap[] value();

    @interface ResultFieldMap {
        // 源字段路径（支持嵌套）
        String sourceField();
        // 目标字段路径（支持嵌套）
        String targetField();
        // 查询服务类
        Class<?> serviceClass();
        // 查询方法名称
        String queryMethod();
        // 查询参数类型（默认String）
        Class<?> queryParamType() default String.class;

        // 新增：第二个参数的源字段（可选）
        String secondSourceField() default "";

        // 新增：第二个参数的类型（可选）
        Class<?> secondQueryParamType() default String.class;

        // 新增：固定的第二个参数值（可选）
        String secondParamValue() default "";
    }
}

