package com.yeejoin.amos.boot.module.cylinder.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 安全追溯-场内车辆
 *
 * @author cpp
 * @date 2023-04-06 15:21:21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="paramVehicle", description="场内车辆技术参数")
public class EquipTechParamVehicleModel extends BaseDto {
    private static final long serialVersionUID = 1L;


            @ApiModelProperty(value = "")
        private String instanceId;
            @ApiModelProperty(value = "")
        private String status;
            @ApiModelProperty(value = "车架编号")
        private String frameNo;
            @ApiModelProperty(value = "发动机（行走电机）编号")
        private String engineNo;
            @ApiModelProperty(value = "动力方式")
        private String powerMode;
            @ApiModelProperty(value = "传动方式")
        private String transmissionMode;
            @ApiModelProperty(value = "车架结构")
        private String frameStructure;
            @ApiModelProperty(value = "驾驶方式")
        private String drivingMode;
            @ApiModelProperty(value = "自重")
        private BigDecimal weight;
            @ApiModelProperty(value = "空载最大运行速度")
        private BigDecimal carryingIdlerMaxRunningSpeed;
            @ApiModelProperty(value = "空载最大起升速度")
        private BigDecimal maxLiftingSpeed;
            @ApiModelProperty(value = "设备保护等级（防爆）")
        private String protectGrade;
            @ApiModelProperty(value = "气体/粉尘组别（防爆）")
        private String gasGroup;
            @ApiModelProperty(value = "温度组别（防爆）")
        private String temperatureGroup;
            @ApiModelProperty(value = "额定起重量")
        private BigDecimal liftingCapacity;
            @ApiModelProperty(value = "系统电压")
        private BigDecimal systemVoltage;
            @ApiModelProperty(value = "载荷中心距")
        private BigDecimal loadCenterDistance;
            @ApiModelProperty(value = "发动机(电机)额定功率")
        private BigDecimal enginePower;
            @ApiModelProperty(value = "最大速度（额载）")
        private BigDecimal maxSpeed;
            @ApiModelProperty(value = "防爆使用场所")
        private String explosionproofPlace;
            @ApiModelProperty(value = "工作装置门架形式")
        private String gantryForm;
            @ApiModelProperty(value = "工作装置空载最大起升高度")
        private BigDecimal maxLiftingHeight;
            @ApiModelProperty(value = "工作装置(全)自由起升高度")
        private BigDecimal freeLiftingHeight;
            @ApiModelProperty(value = "工作装置门架倾角（前）")
        private BigDecimal portalAngleFront;
            @ApiModelProperty(value = "工作装置门架倾角（后）")
        private BigDecimal portalAngleBehind;
            @ApiModelProperty(value = "工作装置最大起升速度（空载）")
        private BigDecimal maxLiftingSpeed1;
            @ApiModelProperty(value = "工作装置最大起升速度（额载）")
        private BigDecimal maxLiftingSpeed2;
            @ApiModelProperty(value = "工作装置最大下降速度（空载）")
        private BigDecimal maxDescentSpeed1;
            @ApiModelProperty(value = "工作装置最大下降速度（额载）")
        private BigDecimal maxDescentSpeed2;
            @ApiModelProperty(value = "整车整备质量")
        private BigDecimal vehicleMass;
            @ApiModelProperty(value = "额定载客数")
        private Integer passengersNumber;
            @ApiModelProperty(value = "最大运行速度")
        private BigDecimal maxRunningSpeed;
            @ApiModelProperty(value = "轴距")
        private BigDecimal wheelBase;
            @ApiModelProperty(value = "轮距（前）")
        private BigDecimal trackWidthFront;
            @ApiModelProperty(value = "轮距（后）")
        private BigDecimal trackWidthBehind;
            @ApiModelProperty(value = "观光列车车厢数")
        private Integer carsNumber;
            @ApiModelProperty(value = "观光列车每节车厢座位数")
        private Integer seatNumber;
            @ApiModelProperty(value = "观光列车牵引车头座位数")
        private Integer tractorSeatNumber;
            @ApiModelProperty(value = "最大行驶坡度")
        private BigDecimal maxDrivingSlope;
            @ApiModelProperty(value = "制动距离")
        private BigDecimal brakingDistance;
            @ApiModelProperty(value = "全长")
        private BigDecimal overallLength;
            @ApiModelProperty(value = "全宽")
        private BigDecimal overallWidth;
            @ApiModelProperty(value = "全高")
        private BigDecimal overallAltitude;
            @ApiModelProperty(value = "最小离地间隙")
        private BigDecimal minGroundClearance;
            @ApiModelProperty(value = "最小外侧转弯半径")
        private BigDecimal minTurningRadius;
            @ApiModelProperty(value = "主要零部件、安全保护和防护装置")
        private String mainParts;

            @ApiModelProperty(value = "监管码")
        private String supervisoryCode;

    
}
