package com.yeejoin.amos.boot.module.cylinder.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author DELL
 */

@AllArgsConstructor
@Getter
public enum EarlyWarningLevelEnum {
    /**
     * 预警等级枚举
     *
     */
    EARLY_WARNING_FIRST_LEVEL("一级预警", "1", "即将超期", "earlyWarning_firstLevel"),
    EARLY_WARNING_SECOND_LEVEL("二级预警", "2", "即将超期", "earlyWarning_secondLevel"),
    EARLY_WARNING_THREE_LEVEL("三级预警", "3", "已超期", "earlyWarning_threeLevel");

    private String name;

    private String level;

    private String status;

    private String code;

    public static EarlyWarningLevelEnum getEumByLevel(String level) {
        Optional<EarlyWarningLevelEnum> op = Arrays.stream(EarlyWarningLevelEnum.values()).filter(e -> e.getLevel().equals(level)).findFirst();
        return op.orElseThrow(() -> new RuntimeException("未知的类型"));
    }
}
