package com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.strategy;

import com.yeejoin.amos.boot.module.common.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplication;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionHistory;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.factory.support.SupportableDocGenerator;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.strategy.common.InspectAppDocCmService;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcInspectionApplicationServiceImpl;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcInspectionHistoryServiceImpl;
import com.yeejoin.amos.boot.module.jyjc.biz.util.WordTemplateUtils;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.component.robot.AmosRequestContext;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import cn.hutool.core.date.StopWatch;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.io.File;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Service
@Slf4j
@RequiredArgsConstructor
public class PipelineDocGeneratorStrategy implements SupportableDocGenerator {

    private final JyjcInspectionApplicationServiceImpl jyjcInspectionApplicationService;

    private final InspectAppDocCmService appDocCmService;

    private final JyjcInspectionHistoryServiceImpl inspectionHistoryService;

    private final AmosRequestContext amosRequestContext;

    @Override
    public boolean support(String equList, String equCategory, String equDefine) {
        return EquipmentClassifityEnum.YLGD.getCode().equals(equList);
    }

    @Override
    public String generate(String appSeq) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("1.组织数据");
        Map<String, Object> params = appDocCmService.getBaseInFo(appSeq);
        JyjcInspectionApplication inspectionApplication = jyjcInspectionApplicationService.getBaseMapper().selectById(appSeq);
        this.setPipelineInfo(params, inspectionApplication);
        stopWatch.stop();
        stopWatch.start("2.文件生成及上传");
        this.setRequestContext();
        String path = this.generatePdfAndUpload(params);
        stopWatch.stop();
        log.info("生成管道报检申请表耗时：{}", stopWatch.prettyPrint(TimeUnit.SECONDS));
        return path;
    }

    private void setRequestContext() {
        RequestContext.setProduct(amosRequestContext.getProduct());
        RequestContext.setAppKey(amosRequestContext.getAppKey());
        RequestContext.setToken(amosRequestContext.getToken());
    }


    private void setPipelineInfo(Map<String, Object> params, JyjcInspectionApplication inspectionApplication) {
        if (inspectionApplication.getStatus().equals(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()))) {
            JyjcInspectionHistory inspectionHistory = inspectionHistoryService.getBySSeq(inspectionApplication.getSequenceNbr());
            if (inspectionHistory != null) {
                // 新报检单记录历史数据的逻辑
                setPipelineExcelData((List<Map<String, Object>>) inspectionHistory.getHistoryData().get("equip"), params);
                params.put("numberOfEquip", inspectionHistory.getHistoryData().get("pipelineLength"));
            } else {
                List<Map<String, Object>> pipelines = setPipelineExcelData(jyjcInspectionApplicationService.getPipelines(inspectionApplication), params);
                params.put("numberOfEquip", JyjcInspectionApplicationServiceImpl.calTotalLength(pipelines));
            }
        } else {
            // 不会走到这，业务需求为已完成时才生成报检申请表
            List<Map<String, Object>> pipelines = setPipelineExcelData(jyjcInspectionApplicationService.getPipelines(inspectionApplication), params);
            params.put("numberOfEquip", JyjcInspectionApplicationServiceImpl.calTotalLength(pipelines));
        }
    }

    private List<Map<String, Object>> setPipelineExcelData(List<Map<String, Object>> pipelines, Map<String, Object> params) {
        params.put("pipelines", pipelines);
        return pipelines;
    }

    private String generatePdfAndUpload(Map<String, Object> formData) {
        String wordPath = "inspect-app-pipeline.ftl";
        String fileName = "检验检测报检申请受理单";
        File pdfFile = null;
        try {
            // 填充模板,  word转pdf
            pdfFile = WordTemplateUtils.wordToPdf(fileName, wordPath, formData);
            // 上传文档到文件服务器
            return WordTemplateUtils.uploadFile(pdfFile, "/tzs/jyjc/inspectApp");
        } catch (Exception e) {
            throw new RuntimeException(e);
        } finally {
            try {
                if (pdfFile != null) {
                    Files.deleteIfExists(pdfFile.toPath());
                }
            } catch (Exception e) {
                log.error("文件找不到，删除失败：{}", e.getMessage());
            }
        }
    }
}
