package com.yeejoin.amos.boot.biz.common.annotation;



import com.yeejoin.amos.boot.biz.common.enums.FileType;

import java.lang.annotation.*;

/**
 * @author chang xiangyu
 * @description 文件校验
 * 使用示例 -> @FileCheck(message = "不支持的文件格式",supportedFileTypes = {FileType.XLS, FileType.XLSX})
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@Documented
public @interface FileCheck {

    /**
     * 校验不通过提示信息
     *
     * @return
     */
    String message() default "不支持的文件格式";

    /**
     * 校验方式
     */
    CheckType type() default CheckType.SUFFIX;

    /**
     * 支持的文件后缀
     *
     * @return
     */
    String[] supportedSuffixes() default {};

    /**
     * 支持的文件类型
     *
     * @return
     */
    FileType[] supportedFileTypes() default {};

    enum CheckType {
        /**
         * 仅校验后缀
         */
        SUFFIX,
        /**
         * 校验文件头(魔数)
         */
        MAGIC_NUMBER,
        /**
         * 同时校验后缀和文件头
         */
        SUFFIX_MAGIC_NUMBER
    }
}