package com.yeejoin.amos.boot.biz.common.annotation;

import java.lang.annotation.*;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@Documented
public @interface TechnicalParameter {
    String key();

    String label();

    ParamType type();

    /**
     *  cb_data_dictionary表的type
     * @return 字典code
     */
    String dictCode() default "";

    String unit() default "";

    /**
     * 匹配条件-设备类别code
     * @return 设备类别
     */
    String[] equCategory() default {};


    /**
     * 匹配条件-设备品种code，设备品种配置空时代表，全部都有
     * @return 设备品种
     */
    String[] equDefine() default {};

    /**
     * 匹配条件-标签如车用气瓶、球罐
     * @return 标签数组
     */
    String[] tags() default {};

    /**
     * 匹配条件-设备类型下默认隐藏字段配置
     * @return 在指定设备类型下需要的隐藏字段
     */
    String[] ignoreCategoryConf() default {};


    enum ParamType {
        STRING, INTEGER, FLOAT, BIG_DECIMAL, BOOLEAN, OBJECT, DATE
    }

}
