package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.module.jg.biz.core.BaseService;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgUseInfoService;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgUseInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgUseInfoMapper;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 使用信息表服务实现类
 *
 * @author system_generator
 * @date 2023-08-16
 */
@Service
public class IdxBizJgUseInfoServiceImpl extends BaseService<IdxBizJgUseInfoMapper, IdxBizJgUseInfo> implements IIdxBizJgUseInfoService {

    public boolean saveOrUpdateData(IdxBizJgUseInfo useInfo){
        return super.saveOrUpdateWithNull(useInfo);
    }

    @Override
    public IdxBizJgUseInfo getOneData(String record) {
        return this.getOne(new QueryWrapper<IdxBizJgUseInfo>().eq("RECORD", record));
    }

    @Override
    public List<IdxBizJgUseInfo> getUseInfoListByEquIds(List<String> equIds) {
        QueryWrapper<IdxBizJgUseInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().in(IdxBizJgUseInfo::getRecord, equIds);
        return list(queryWrapper);
    }

    @Override
    public boolean saveBatch(List<IdxBizJgUseInfo> useInfoList) {
        return super.saveBatch(useInfoList);
    }

    @Override
    public boolean saveOrUpdateBatch(List<IdxBizJgUseInfo> useInfoList) {
        return super.saveOrUpdateBatch(useInfoList);
    }

    @Override
    public void updateBatchByRecord(List<IdxBizJgUseInfo> toUpdateUseInfoList) {
        toUpdateUseInfoList.forEach(useInfo -> super.update(useInfo, new LambdaUpdateWrapper<IdxBizJgUseInfo>().eq(IdxBizJgUseInfo::getRecord, useInfo.getRecord())));
    }
}