package com.yeejoin.amos.api.openapi.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.component.event.RestEventTrigger;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import com.yeejoin.amos.api.common.restful.utils.ResponseHelper;
import com.yeejoin.amos.api.common.restful.utils.ResponseModel;
import com.yeejoin.amos.api.openapi.face.model.CylinderFillingCheckModel;
import com.yeejoin.amos.api.openapi.face.model.CylinderFillingExamineModel;
import com.yeejoin.amos.api.openapi.face.model.CylinderFillingExamineModelList;
import com.yeejoin.amos.api.openapi.face.model.CylinderFillingModel;
import com.yeejoin.amos.api.openapi.face.model.CylinderFillingModelList;
import com.yeejoin.amos.api.openapi.face.model.CylinderFillingRecordModel;
import com.yeejoin.amos.api.openapi.face.model.CylinderInfoModel;
import com.yeejoin.amos.api.openapi.face.model.CylinderInfoModelList;
import com.yeejoin.amos.api.openapi.face.model.CylinderInspectionModel;
import com.yeejoin.amos.api.openapi.face.model.CylinderInspectionModelList;
import com.yeejoin.amos.api.openapi.face.model.CylinderTagsModel;
import com.yeejoin.amos.api.openapi.face.model.CylinderTagsModelList;
import com.yeejoin.amos.api.openapi.face.model.CylinderUnitModel;
import com.yeejoin.amos.api.openapi.face.model.CylinderUnitModelList;
import com.yeejoin.amos.api.openapi.face.service.CylinderFillingCheckService;
import com.yeejoin.amos.api.openapi.face.service.CylinderFillingExamineService;
import com.yeejoin.amos.api.openapi.face.service.CylinderFillingRecordService;
import com.yeejoin.amos.api.openapi.face.service.CylinderFillingService;
import com.yeejoin.amos.api.openapi.face.service.CylinderInfoService;
import com.yeejoin.amos.api.openapi.face.service.CylinderInspectionService;
import com.yeejoin.amos.api.openapi.face.service.CylinderTagsService;
import com.yeejoin.amos.api.openapi.face.service.CylinderUnitService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;

@RestController
@RequestMapping(value = "/cylinder")
@Api(tags = "cylinder-气瓶数据对接")
public class CylinderController {
	private static final Logger logger = LogManager.getLogger(CylinderController.class);
	@Autowired
	private CylinderUnitService cylinderUnitService;
	@Autowired
	private CylinderFillingCheckService cylinderFillingCheckService;
	@Autowired
	private CylinderFillingExamineService cylinderFillingExamineService;
	@Autowired
	private CylinderFillingRecordService cylinderFillingRecordService;
	@Autowired
	private CylinderFillingService cylinderFillingService;
	@Autowired
	private CylinderInfoService cylinderInfoService;
	@Autowired
	private CylinderInspectionService cylinderInspectionService;
	@Autowired
	private CylinderTagsService cylinderTagsService;

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶企业信息")
	@PostMapping(value = "/unit")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderUnit(@RequestBody String unitData) throws Exception {

		logger.info("气瓶企业信息"+unitData);
		JSONObject jsonobject = JSONObject.fromObject(unitData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("unit", CylinderUnitModel.class);

		CylinderUnitModelList cylinderUnitModelList = (CylinderUnitModelList) JSONObject.toBean(jsonobject,
				CylinderUnitModelList.class, classMap);
		cylinderUnitService.createCylinderUnit(cylinderUnitModelList.getUnit());
		return ResponseHelper.buildResponse("");
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶基础数据")
	@PostMapping(value = "/info")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderInfo(@RequestBody String infoData) throws Exception {

		logger.info("气瓶基础数据"+infoData);
		JSONObject jsonobject = JSONObject.fromObject(infoData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("info", CylinderInfoModel.class);
		CylinderInfoModelList cylinderInfoModelList = (CylinderInfoModelList) JSONObject.toBean(jsonobject,
				CylinderInfoModelList.class, classMap);
		cylinderInfoService.createCylinderInfo(cylinderInfoModelList.getInfo());
		return ResponseHelper.buildResponse("");
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶标签数据")
	@PostMapping(value = "/tag")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderTagInfo(@RequestBody String tagData) throws Exception {

		logger.info("气瓶标签数据"+tagData);
		JSONObject jsonobject = JSONObject.fromObject(tagData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("tag", CylinderTagsModel.class);
		CylinderTagsModelList cylinderTagsModelList = (CylinderTagsModelList) JSONObject.toBean(jsonobject,
				CylinderTagsModelList.class, classMap);
		cylinderTagsService.createCylinderTag(cylinderTagsModelList.getTag());
		return ResponseHelper.buildResponse("");
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶检验数据")
	@PostMapping(value = "/inspection")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderInspectionInfo(@RequestBody String inspectionData) throws Exception {

		logger.info("气瓶检验数据"+inspectionData);
		JSONObject jsonobject = JSONObject.fromObject(inspectionData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("inspection", CylinderInspectionModel.class);
		CylinderInspectionModelList cylinderInspectionModelList = (CylinderInspectionModelList) JSONObject
				.toBean(jsonobject, CylinderInspectionModelList.class, classMap);
		cylinderInspectionService.createCylinderInspection(cylinderInspectionModelList.getInspection());
		return ResponseHelper.buildResponse("");
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶充装数据")
	@PostMapping(value = "/filling")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderFillingInfo(@RequestBody String fillingData) throws Exception {

		logger.info("气瓶充装数据"+fillingData);
		JSONObject jsonobject = JSONObject.fromObject(fillingData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("fillingBefore", CylinderFillingModel.class);
		classMap.put("filling", CylinderFillingRecordModel.class);
		classMap.put("fillingAfter", CylinderFillingCheckModel.class);
		CylinderFillingModelList cylinderFillingModelList = (CylinderFillingModelList) JSONObject.toBean(jsonobject,
				CylinderFillingModelList.class, classMap);

		List<CylinderFillingModel> fillingBefores = cylinderFillingModelList.getFillingBefore();
		List<CylinderFillingRecordModel> fillings = cylinderFillingModelList.getFilling();
		List<CylinderFillingCheckModel> fillingAfters = cylinderFillingModelList.getFillingAfter();
		if (ValidationUtil.isEmpty(fillingBefores) && ValidationUtil.isEmpty(fillings) && ValidationUtil.isEmpty(fillingAfters)) {
			throw new BadRequest("液化气体气瓶充装信息-充装前检查信息、液化气体气瓶充装信息-充装记录信息、液化气体气瓶充装信息-充装后复查信息为空.");
		}
		cylinderFillingService.createCylinderFillingBefore(fillingBefores);			
		cylinderFillingRecordService.createCylinderFilling(fillings);	
		cylinderFillingCheckService.createCylinderFillingAfter(fillingAfters);
//		if (ValidationUtil.isEmpty(fillings)) {
//			throw new BadRequest("液化气体气瓶充装信息-充装记录信息为空.");
//		}else {
//		}
//		if (ValidationUtil.isEmpty(fillingAfters)) {
//			throw new BadRequest("液化气体气瓶充装信息-充装后复查信息为空.");
//		}else {
//		}
		return ResponseHelper.buildResponse("");
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶充装审核数据")
	@PostMapping(value = "/fillingAudit")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderFillingAudit(@RequestBody String fillingAuditData) throws Exception {

		logger.info("气瓶充装审核数据"+fillingAuditData);
		JSONObject jsonobject = JSONObject.fromObject(fillingAuditData);
		Map<String, Class> classMap = new HashMap<String, Class>();
		classMap.put("fillingAudit", CylinderFillingExamineModel.class);
		CylinderFillingExamineModelList cylinderFillingExamineModelList = (CylinderFillingExamineModelList) JSONObject
				.toBean(jsonobject, CylinderFillingExamineModelList.class, classMap);
		cylinderFillingExamineService.createCylinderFillingExamine(cylinderFillingExamineModelList.getFillingAudit());
		return ResponseHelper.buildResponse("");
	}
}
