package com.yeejoin.amos.api.openapi.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.api.common.restful.utils.ResponseHelper;
import com.yeejoin.amos.api.common.restful.utils.ResponseModel;
import com.yeejoin.amos.api.openapi.face.model.CylinderTableModel;
import com.yeejoin.amos.api.openapi.face.model.CylinderUnitTree;
import com.yeejoin.amos.api.openapi.face.orm.entity.OpenapiBizToken;
import com.yeejoin.amos.api.openapi.face.service.CylinderDateInfoService;
import com.yeejoin.amos.api.openapi.face.service.CylinderFillingCheckService;
import com.yeejoin.amos.api.openapi.face.service.CylinderFillingExamineService;
import com.yeejoin.amos.api.openapi.face.service.CylinderFillingRecordService;
import com.yeejoin.amos.api.openapi.face.service.CylinderFillingService;
import com.yeejoin.amos.api.openapi.face.service.CylinderInfoService;
import com.yeejoin.amos.api.openapi.face.service.CylinderInspectionService;
import com.yeejoin.amos.api.openapi.face.service.CylinderTagsService;
import com.yeejoin.amos.api.openapi.face.service.CylinderUnitService;
import com.yeejoin.amos.api.openapi.face.service.OpenapiBizTokenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping(value = "/cylinderPage")
@Api(tags = "气瓶首页controller")
public class CylinderPageController {
	private static final Logger logger = LogManager.getLogger(CylinderPageController.class);
	@Autowired
	private CylinderUnitService cylinderUnitService;
	@Autowired
	private CylinderFillingCheckService cylinderFillingCheckService;
	@Autowired
	private CylinderFillingExamineService cylinderFillingExamineService;
	@Autowired
	private CylinderFillingRecordService cylinderFillingRecordService;
	@Autowired
	private CylinderFillingService cylinderFillingService;
	@Autowired
	private CylinderInfoService cylinderInfoService;
	@Autowired
	private CylinderInspectionService cylinderInspectionService;
	@Autowired
	private CylinderTagsService cylinderTagsService;
	@Autowired
	private OpenapiBizTokenService openapiBizTokenService;
	@Autowired
	private CylinderDateInfoService cylinderDateInfoService;

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "服务商树")
	@GetMapping(value = "/serviceProvider")
	public ResponseModel<List<CylinderUnitTree>> cylinderUnit() throws Exception {
        List<CylinderUnitTree> result = new ArrayList<>();
		List<String> serviceList = openapiBizTokenService.getServiceList();
        serviceList.stream().forEach(s -> {

            CylinderUnitTree temp = new CylinderUnitTree();
            List<OpenapiBizToken> children = openapiBizTokenService.list(new LambdaQueryWrapper<OpenapiBizToken>().eq(OpenapiBizToken::getDeveloperAgency,s)
                    .eq(OpenapiBizToken::getDataType,"cyl"));
            List<CylinderUnitTree> childrenList = new ArrayList<>();
            children.stream().forEach(c ->{
                CylinderUnitTree tt = new CylinderUnitTree();
                tt.setUnitName(c.getApiCompanyName());
                tt.setAppId(c.getAppId());
                childrenList.add(tt);
            });
            temp.setUnitName(s);
            temp.setChildren(childrenList);
            result.add(temp);
        });
		return ResponseHelper.buildResponse(result);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "根据搜索信息获取表格数据")
	@GetMapping(value = "/getTableInfo")
	public ResponseModel<List<CylinderTableModel>> cylinderTableInfo(@RequestParam(value = "serviceName",required = false) String serviceName,
																	 @RequestParam(value = "appId",required = false) String appId,
																	 @RequestParam(value = "startTime",required = false) String startTime,
																	 @RequestParam(value = "endTime",required = false) String endTime)  {
        // 先同步或者更新今日数据
        cylinderDateInfoService.updateTodayDate();
        // 查询数据
        List<CylinderTableModel> result = cylinderDateInfoService.selectTodayDate(serviceName, appId, startTime, endTime);
		return ResponseHelper.buildResponse(result);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "同步气瓶数据")
	@GetMapping(value = "/initCylinderNum")
	public ResponseModel<Boolean> initCylinderNum()  {
        Boolean result = cylinderDateInfoService.initCylinderNum();
		return ResponseHelper.buildResponse(result);
	};








}
