package com.yeejoin.amos.boot.module.common.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.OrgUsrDto;
import com.yeejoin.amos.boot.module.common.api.entity.MaintenanceCompany;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* 维保单位 Mapper 接口
*
* @author system_generator
* @date 2021-07-16
*/
public interface MaintenanceCompanyMapper extends BaseMapper<MaintenanceCompany> {
    /**
     * 查询机场单位信息 (不带分页)
     * @param seq
     * @return
     */
    public List<OrgUsrDto> selectOrgUsrList (@Param("seq") Long seq);

    /**
     * 查询机场单位信息 (带分页)
     * @param page
     * @param seq
     * @return
     */
    public Page<OrgUsrDto> selectOrgUsrPageList(Page page, @Param("seq") Long seq);

    List<MaintenanceCompany> findByCodeAndType(String code, String type);

    List<MaintenanceCompany> findByInstanceIdAndType(Long instanceId, String type);
}
