package com.yeejoin.equipmanage.common.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_alarm")
@ApiModel(value="Alarm对象", description="")
public class Alarm extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "标题")
    private String title;

    @ApiModelProperty(value = "内容")
    private String content;

    @ApiModelProperty(value = "告警类型  ：库存告警，保养告警，借用告警 ")
    private Long typeId;

    @ApiModelProperty(value = "展示平台")
    private String platform;

    @ApiModelProperty(value = "是否恢复")
    private Integer isRecovery;

    @ApiModelProperty(value = "是否失效")
    private Integer isInvalid;

    @ApiModelProperty(value = "告警单据id")
    private Long warningId;

    @ApiModelProperty(value = "创建人")
    private Long creatorId;

    @ApiModelProperty(value = "发布时间")
    private Date publishTime;

    @ApiModelProperty(value = "公司orgcode")
    private String orgCode;

    @ApiModelProperty(value = "创建时间")
    private Date dateCreated;

    @ApiModelProperty(value = "RFID标识")
    private String rfid;

    @ApiModelProperty(value = "告警级别ID:当前为两种，保养，检查，库存，借用为1级，其它入库，未识别为2级")
    private Integer alarmGradeTypeId;

    @ApiModelProperty(value = "相关单位编码(保养超期)")
    private String relativeOrgCode;

    @ApiModelProperty(value = "已读的用户集合 ")
    private String readed;

    @ApiModelProperty(value = "公司名")
    private String companyName;

    @ApiModelProperty(value = "部门code")
    private String departmentOrgcode;

    @ApiModelProperty(value = "部门名")
    private String departmentName;


}
